/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.terracer;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.terracer.ReverseTerraceAction;
import org.openstreetmap.josm.plugins.terracer.TerracerAction;
import org.openstreetmap.josm.tools.Destroyable;

public class TerracerPlugin
extends Plugin
implements Destroyable {
    private List<JosmAction> actions = Arrays.asList(new JosmAction[]{new TerracerAction(), new ReverseTerraceAction()});

    public TerracerPlugin(PluginInformation info) {
        super(info);
        for (JosmAction action : this.actions) {
            MainMenu.add((JMenu)MainApplication.getMenu().moreToolsMenu, (JosmAction)action);
        }
    }

    public void destroy() {
        JMenu moreToolsMenu = MainApplication.getMenu().moreToolsMenu;
        Map<Action, Component> actionsMap = Arrays.asList(moreToolsMenu.getMenuComponents()).stream().filter(JMenuItem.class::isInstance).map(JMenuItem.class::cast).collect(Collectors.toMap(AbstractButton::getAction, component -> component));
        for (Map.Entry<Action, Component> action : actionsMap.entrySet()) {
            if (!this.actions.contains(action.getKey())) continue;
            moreToolsMenu.remove(action.getValue());
        }
        this.actions.forEach(JosmAction::destroy);
    }
}

