/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ASTFactory;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.gui.MainFrameModel;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.HashMap;
import java.util.Map;

public class ParseTreeTablePresentation {
    private static final String UNKNOWN_COLUMN_MSG = "Unknown column";
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};
    private final Object root;
    private final Map<DetailAST, DetailNode> blockCommentToJavadocTree = new HashMap<DetailAST, DetailNode>();
    private MainFrameModel.ParseMode parseMode;

    public ParseTreeTablePresentation(DetailAST parseTree) {
        this.root = ParseTreeTablePresentation.createArtificialTreeRoot();
        this.setParseTree(parseTree);
    }

    protected final void setParseTree(DetailAST parseTree) {
        ((AST)this.root).setFirstChild((AST)((Object)parseTree));
    }

    protected void setParseMode(MainFrameModel.ParseMode mode) {
        this.parseMode = mode;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        Class columnClass;
        switch (column) {
            case 0: {
                columnClass = ParseTreeTableModel.class;
                break;
            }
            case 1: 
            case 4: {
                columnClass = String.class;
                break;
            }
            case 2: 
            case 3: {
                columnClass = Integer.class;
                break;
            }
            default: {
                throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
            }
        }
        return columnClass;
    }

    public Object getValueAt(Object node, int column) {
        Object result = node instanceof DetailNode ? ParseTreeTablePresentation.getValueAtDetailNode((DetailNode)node, column) : ParseTreeTablePresentation.getValueAtDetailAST((DetailAST)node, column);
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = parent instanceof DetailNode ? ((DetailNode)parent).getChildren()[index] : this.getChildAtDetailAst((DetailAST)parent, index);
        return result;
    }

    public int getChildCount(Object parent) {
        int result = parent instanceof DetailNode ? ((DetailNode)parent).getChildren().length : (this.parseMode == MainFrameModel.ParseMode.JAVA_WITH_JAVADOC_AND_COMMENTS && ((AST)parent).getType() == 183 && JavadocUtil.isJavadocComment(((DetailAST)parent).getParent()) ? 1 : ((DetailAST)parent).getChildCount());
        return result;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isCellEditable(int column) {
        return false;
    }

    private static DetailAST createArtificialTreeRoot() {
        ASTFactory factory = new ASTFactory();
        factory.setASTNodeClass(DetailAstImpl.class.getName());
        return (DetailAST)((Object)factory.create(1, "ROOT"));
    }

    private Object getChildAtDetailAst(DetailAST parent, int index) {
        Object result;
        if (this.parseMode == MainFrameModel.ParseMode.JAVA_WITH_JAVADOC_AND_COMMENTS && parent.getType() == 183 && JavadocUtil.isJavadocComment(parent.getParent())) {
            result = this.getJavadocTree(parent.getParent());
        } else {
            DetailAST child = parent.getFirstChild();
            for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
                child = child.getNextSibling();
            }
            result = child;
        }
        return result;
    }

    private static Object getValueAtDetailNode(DetailNode node, int column) {
        Object value;
        switch (column) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                value = JavadocUtil.getTokenName(node.getType());
                break;
            }
            case 2: {
                value = node.getLineNumber();
                break;
            }
            case 3: {
                value = node.getColumnNumber();
                break;
            }
            case 4: {
                value = node.getText();
                break;
            }
            default: {
                throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
            }
        }
        return value;
    }

    private static Object getValueAtDetailAST(DetailAST ast, int column) {
        Object value;
        switch (column) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                value = TokenUtil.getTokenName(ast.getType());
                break;
            }
            case 2: {
                value = ast.getLineNo();
                break;
            }
            case 3: {
                value = ast.getColumnNo();
                break;
            }
            case 4: {
                value = ast.getText();
                break;
            }
            default: {
                throw new IllegalStateException(UNKNOWN_COLUMN_MSG);
            }
        }
        return value;
    }

    private DetailNode getJavadocTree(DetailAST blockComment) {
        DetailNode javadocTree = this.blockCommentToJavadocTree.get(blockComment);
        if (javadocTree == null) {
            javadocTree = new JavadocDetailNodeParser().parseJavadocAsDetailNode(blockComment).getTree();
            this.blockCommentToJavadocTree.put(blockComment, javadocTree);
        }
        return javadocTree;
    }
}

