/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.CommonASTWithHiddenTokens;
import antlr.Token;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.BitSet;

public final class DetailAstImpl
extends CommonASTWithHiddenTokens
implements DetailAST {
    private static final long serialVersionUID = -2580884815577559874L;
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int lineNo = Integer.MIN_VALUE;
    private int columnNo = Integer.MIN_VALUE;
    private int childCount = Integer.MIN_VALUE;
    private DetailAstImpl parent;
    private DetailAstImpl previousSibling;
    private BitSet branchTokenTypes;

    @Override
    public void initialize(Token tok) {
        super.initialize(tok);
        this.lineNo = tok.getLine();
        this.columnNo = tok.getColumn() - 1;
    }

    @Override
    public void initialize(AST ast) {
        DetailAstImpl detailAst = (DetailAstImpl)ast;
        this.setText(detailAst.getText());
        this.setType(detailAst.getType());
        this.lineNo = detailAst.getLineNo();
        this.columnNo = detailAst.getColumnNo();
        this.hiddenAfter = detailAst.getHiddenAfter();
        this.hiddenBefore = detailAst.getHiddenBefore();
    }

    @Override
    public void setFirstChild(AST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this);
        super.setFirstChild(ast);
        if (ast != null) {
            ((DetailAstImpl)ast).setParent(this);
        }
    }

    @Override
    public void setNextSibling(AST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        super.setNextSibling(ast);
        if (ast != null && this.parent != null) {
            ((DetailAstImpl)ast).setParent(this.parent);
        }
        if (ast != null) {
            ((DetailAstImpl)ast).previousSibling = this;
        }
    }

    public void addPreviousSibling(DetailAST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        if (ast != null) {
            DetailAstImpl previousSiblingNode = this.previousSibling;
            DetailAstImpl astImpl = (DetailAstImpl)ast;
            if (previousSiblingNode != null) {
                astImpl.previousSibling = previousSiblingNode;
                previousSiblingNode.setNextSibling(astImpl);
            } else if (this.parent != null) {
                this.parent.setFirstChild(astImpl);
            }
            astImpl.setNextSibling(this);
            this.previousSibling = astImpl;
        }
    }

    public void addNextSibling(DetailAST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        if (ast != null) {
            DetailAstImpl nextSibling = this.getNextSibling();
            DetailAstImpl astImpl = (DetailAstImpl)ast;
            if (nextSibling != null) {
                astImpl.setNextSibling(nextSibling);
                nextSibling.previousSibling = astImpl;
            }
            astImpl.previousSibling = this;
            this.setNextSibling(astImpl);
        }
    }

    @Override
    public void addChild(AST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this);
        if (ast != null) {
            DetailAstImpl astImpl = (DetailAstImpl)ast;
            astImpl.setParent(this);
            astImpl.previousSibling = (DetailAstImpl)this.getLastChild();
        }
        super.addChild(ast);
    }

    @Override
    public int getChildCount() {
        if (this.childCount == Integer.MIN_VALUE) {
            this.childCount = 0;
            for (AST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                ++this.childCount;
            }
        }
        return this.childCount;
    }

    @Override
    public int getChildCount(int type) {
        int count = 0;
        for (AST ast = this.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != type) continue;
            ++count;
        }
        return count;
    }

    private void setParent(DetailAstImpl parent) {
        DetailAstImpl instance = this;
        do {
            instance.clearBranchTokenTypes();
            instance.parent = parent;
        } while ((instance = instance.getNextSibling()) != null);
    }

    @Override
    public DetailAST getParent() {
        return this.parent;
    }

    @Override
    public int getLineNo() {
        int resultNo = -1;
        if (this.lineNo == Integer.MIN_VALUE && (resultNo = DetailAstImpl.findLineNo(this.getFirstChild())) == -1) {
            resultNo = DetailAstImpl.findLineNo(this.getNextSibling());
        }
        if (resultNo == -1) {
            resultNo = this.lineNo;
        }
        return resultNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public int getColumnNo() {
        int resultNo = -1;
        if (this.columnNo == Integer.MIN_VALUE && (resultNo = DetailAstImpl.findColumnNo(this.getFirstChild())) == -1) {
            resultNo = DetailAstImpl.findColumnNo(this.getNextSibling());
        }
        if (resultNo == -1) {
            resultNo = this.columnNo;
        }
        return resultNo;
    }

    public void setColumnNo(int columnNo) {
        this.columnNo = columnNo;
    }

    @Override
    public DetailAST getLastChild() {
        DetailAST ast;
        for (ast = this.getFirstChild(); ast != null && ast.getNextSibling() != null; ast = ast.getNextSibling()) {
        }
        return ast;
    }

    private static int findColumnNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtil.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getColumnNo();
            break;
        }
        return resultNo;
    }

    private static int findLineNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtil.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getLineNo();
            break;
        }
        return resultNo;
    }

    private BitSet getBranchTokenTypes() {
        if (this.branchTokenTypes == null) {
            this.branchTokenTypes = new BitSet();
            this.branchTokenTypes.set(this.getType());
            for (DetailAstImpl child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.branchTokenTypes.or(childTypes);
            }
        }
        return this.branchTokenTypes;
    }

    @Override
    public boolean branchContains(int type) {
        return this.getBranchTokenTypes().get(type);
    }

    @Override
    public DetailAST getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public DetailAST findFirstToken(int type) {
        DetailAstImpl returnValue = null;
        for (DetailAST ast = this.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != type) continue;
            returnValue = ast;
            break;
        }
        return returnValue;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }

    @Override
    public DetailAstImpl getNextSibling() {
        return (DetailAstImpl)super.getNextSibling();
    }

    @Override
    public DetailAstImpl getFirstChild() {
        return (DetailAstImpl)super.getFirstChild();
    }

    private static void clearChildCountCache(DetailAstImpl ast) {
        if (ast != null) {
            ast.childCount = Integer.MIN_VALUE;
        }
    }

    private void clearBranchTokenTypes() {
        DetailAstImpl prevParent = this.parent;
        while (prevParent != null) {
            prevParent.branchTokenTypes = null;
            prevParent = prevParent.parent;
        }
    }
}

