/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class InefficientReplaceAll
extends OpcodeStackDetector
implements StatelessDetector {
    private static final Logger LOGGER = Logger.getLogger(InefficientReplaceAll.class.getName());
    private static final List<MethodDescriptor> methods = Collections.singletonList(new MethodDescriptor("", "replaceAll", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"));
    private final BugAccumulator bugAccumulator;
    private static final Pattern REGEX_CHARS_PATTERN = Pattern.compile("[" + Pattern.quote("-.\\[]{}()<>*+=?^$|") + "]");

    public InefficientReplaceAll(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (InefficientReplaceAll.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods)) {
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    @Override
    public void visit(Method obj) {
        LOGGER.log(Level.FINE, "------------------- Analyzing {0} ----------------", obj.getName());
        super.visit(obj);
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        Optional<String> firstArgument;
        LOGGER.log(Level.FINE, "Opcode: {0}", Const.getOpcodeName((int)seen));
        if ((seen == 182 || seen == 185) && "replaceAll".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;".equals(this.getSigConstantOperand()) && this.hasConstantArguments() && (firstArgument = this.getFirstArgument()).isPresent() && !REGEX_CHARS_PATTERN.matcher(firstArgument.get()).find()) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IRA_INEFFICIENT_REPLACEALL", 3).addClassAndMethod(this), this);
        }
    }

    private Optional<String> getFirstArgument() {
        Object value = this.getStack().getStackItem(InefficientReplaceAll.getNumberArguments(this.getMethodDescriptorOperand().getSignature()) - 1).getConstant();
        return Optional.ofNullable(Objects.toString(value, null));
    }

    private boolean hasConstantArguments() {
        int nArgs = InefficientReplaceAll.getNumberArguments(this.getMethodDescriptorOperand().getSignature());
        for (int i = 0; i < nArgs; ++i) {
            if (this.getStack().getStackItem(i).getConstant() != null) continue;
            return false;
        }
        return true;
    }
}

