/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.util.HTML;
import javax.annotation.Nonnull;

public class BugPattern
implements Comparable<BugPattern> {
    private final String type;
    private final String abbrev;
    private final String category;
    private final boolean experimental;
    private final String shortDescription;
    private final String longDescription;
    private final String detailText;
    private final String url;
    final int cweid;
    int priorityAdjustment;
    private boolean deprecated;
    static final BugPattern REALLY_UNKNOWN = new BugPattern("REALLY_UNKNOWN", "TEST", "CORRECTNESS", false, "Unknown warning; core bug patterns not found", "Unknown warning BUG_PATTERN in {1}; core bug patterns not found", "<p>A warning was recorded, but SpotBugs can't find the description of this bug pattern and so can't describe it. This should occur only in cases of a bug in SpotBugs or its configuration, or perhaps if an analysis was generated using a plugin, but that plugin is not currently loaded. </p>", null, 0);

    public BugPattern(String type, String abbrev, String category, boolean experimental, String shortDescription, String longDescription, String detailText, String bugsUrl, int cweid) {
        this.type = type;
        this.abbrev = abbrev.intern();
        this.category = category.intern();
        this.experimental = experimental;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.detailText = detailText;
        this.cweid = cweid;
        this.url = bugsUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    @Nonnull
    public BugCode getBugCode() {
        return DetectorFactoryCollection.instance().getBugCode(this.abbrev);
    }

    public String getCategory() {
        return this.category;
    }

    public int getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public void adjustPriority(int change) {
        this.priorityAdjustment += change;
    }

    public String getCategoryAbbrev() {
        String categoryAbbrev = null;
        BugCategory bcat = DetectorFactoryCollection.instance().getBugCategory(this.getCategory());
        if (bcat != null) {
            categoryAbbrev = bcat.getAbbrev();
        }
        if (categoryAbbrev == null) {
            categoryAbbrev = "X";
        }
        return categoryAbbrev;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public String getDetailPlainText() {
        try {
            return HTML.convertHtmlSnippetToText(this.detailText);
        }
        catch (Exception e) {
            return this.detailText;
        }
    }

    public String getDetailHTML() {
        return this.getDetailHTML(this.getDetailText());
    }

    public String getDetailHTML(String detailText) {
        StringBuilder buf = new StringBuilder();
        buf.append("<!DOCTYPE HTML\">\n");
        buf.append("<HTML><HEAD><TITLE>");
        buf.append(this.getShortDescription());
        buf.append("</TITLE></HEAD><BODY><H1>");
        buf.append(this.wrapInDescriptionLink(this.getShortDescription()));
        buf.append("</H1>\n");
        buf.append(detailText);
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    public String wrapInDescriptionLink(String text) {
        if (this.url == null) {
            return text;
        }
        return "<a href=\"" + this.url + "#" + this.type + "\">" + text + "</a>";
    }

    @Override
    public int compareTo(BugPattern other) {
        return this.type.compareTo(other.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugPattern)) {
            return false;
        }
        BugPattern other = (BugPattern)o;
        return this.type.equals(other.type);
    }

    public int getCWEid() {
        return this.cweid;
    }

    public String toString() {
        return "BugPattern[" + this.type + "]";
    }

    void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

