/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import model.PresetCounter;
import model.TagCatalog;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;

public class IndoorHelperModel {
    private TagCatalog tags = new TagCatalog();
    private PresetCounter counter = new PresetCounter();

    public List<Tag> getObjectTags(TagCatalog.IndoorObject object) {
        return this.tags.getTags(object);
    }

    public void addTagsToOSM(TagCatalog.IndoorObject object, List<Tag> userTags) {
        if (!MainApplication.getLayerManager().getEditDataSet().selectionEmpty() && !OsmDataManager.getInstance().getInProgressSelection().isEmpty()) {
            DataSet ds = OsmDataManager.getInstance().getEditDataSet();
            List<Tag> tags = this.getObjectTags(object);
            Collection relations = ds.getRelations();
            Relation relationToAdd = null;
            tags.addAll(userTags);
            this.counter.count(object);
            relationToAdd = this.getRelationFromDataSet(ds, relations);
            if (relationToAdd != null) {
                for (Tag t : tags) {
                    UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand((OsmPrimitive)relationToAdd, t.getKey(), t.getValue()));
                }
            } else {
                for (Tag t : tags) {
                    UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(OsmDataManager.getInstance().getInProgressSelection(), t.getKey(), t.getValue()));
                }
            }
        } else if (MainApplication.getLayerManager().getEditDataSet().selectionEmpty()) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"No data selected.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }

    public void addTagsToOSM(TagCatalog.IndoorObject object) {
        DataSet editDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (editDataSet != null) {
            Collection selection = OsmDataManager.getInstance().getInProgressSelection();
            if (!editDataSet.selectionEmpty() && !selection.isEmpty()) {
                List<Tag> tags = this.getObjectTags(object);
                this.counter.count(object);
                for (Tag t : tags) {
                    UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(selection, t.getKey(), t.getValue()));
                }
            } else if (editDataSet.selectionEmpty()) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"No data selected.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
    }

    public void addTagsToOSM(List<Tag> userTags) {
        if (!MainApplication.getLayerManager().getEditDataSet().selectionEmpty() && !OsmDataManager.getInstance().getInProgressSelection().isEmpty()) {
            for (Tag t : userTags) {
                UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(OsmDataManager.getInstance().getInProgressSelection(), t.getKey(), t.getValue()));
            }
        } else if (MainApplication.getLayerManager().getEditDataSet().selectionEmpty()) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"No data selected.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }

    public void addRelation(String role) {
        Relation newRelation = new Relation();
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        if (!MainApplication.getLayerManager().getEditDataSet().selectionEmpty()) {
            for (OsmPrimitive osm : ds.getSelected()) {
                RelationMember newMember = new RelationMember(role == null ? "" : role, osm);
                newRelation.addMember(newMember);
            }
        }
        UndoRedoHandler.getInstance().add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newRelation));
    }

    public void editRelation(String role, Collection<OsmPrimitive> innerRelation) {
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        Collection relations = ds.getRelations();
        Relation relation = this.getRelationFromDataSet(ds, relations);
        if (!MainApplication.getLayerManager().getEditDataSet().selectionEmpty() && !OsmDataManager.getInstance().getInProgressSelection().isEmpty() && !innerRelation.isEmpty() && this.getRole(ds, relations).equals("outer")) {
            for (OsmPrimitive osm : innerRelation) {
                RelationMember newMember = new RelationMember(role == null ? "" : role, osm);
                relation.addMember(newMember);
            }
        } else if (MainApplication.getLayerManager().getEditDataSet().selectionEmpty() || innerRelation.isEmpty()) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"No data selected.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        } else if (!this.getRole(ds, relations).equals("outer")) {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"No relation or no relation member with role \"outer\" selected.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }

    public List<TagCatalog.IndoorObject> getPresetRanking() {
        return this.counter.getRanking();
    }

    private Relation getRelationFromDataSet(DataSet ds, Collection<Relation> relations) {
        for (Relation r : relations) {
            for (RelationMember rm : r.getMembers()) {
                for (OsmPrimitive osm : ds.getSelected()) {
                    if (!rm.refersTo(osm)) continue;
                    return r;
                }
            }
        }
        return null;
    }

    private String getRole(DataSet ds, Collection<Relation> relations) {
        if (this.isRelationMember(ds, relations)) {
            for (Relation r : relations) {
                for (RelationMember rm : r.getMembers()) {
                    for (OsmPrimitive osm : ds.getSelected()) {
                        if (!rm.refersTo(osm)) continue;
                        return rm.getRole();
                    }
                }
            }
        }
        return "";
    }

    private boolean isRelationMember(DataSet ds, Collection<Relation> relations) {
        for (Relation r : relations) {
            for (RelationMember rm : r.getMembers()) {
                for (OsmPrimitive osm : ds.getSelected()) {
                    if (!rm.refersTo(osm)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

