/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.download;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadData;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadSource;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CadastreDownloadSourcePanel
extends AbstractDownloadSourcePanel<CadastreDownloadData> {
    public static final String SIMPLE_NAME = "cadastredownloadpanel";
    public static final NamedColorProperty BG_COLOR = new NamedColorProperty(I18n.marktr((String)"cadastre download panel"), new Color(255, 204, 51));
    private final JCheckBox cbDownloadBuilding;
    private final JCheckBox cbDownloadAddress;
    private final JCheckBox cbDownloadSymbol;
    private final JCheckBox cbDownloadWater;
    private final JCheckBox cbDownloadParcel;
    private final JCheckBox cbDownloadParcelNum;
    private final JCheckBox cbDownloadSection;
    private final JCheckBox cbDownloadLocality;
    private final JCheckBox cbDownloadCommune;
    private final JLabel sizeCheck = new JLabel();
    private static final BooleanProperty DOWNLOAD_BUILDING = new BooleanProperty("download.cadastrefr.building", true);
    private static final BooleanProperty DOWNLOAD_ADDRESS = new BooleanProperty("download.cadastrefr.address", true);
    private static final BooleanProperty DOWNLOAD_SYMBOL = new BooleanProperty("download.cadastrefr.symbol", true);
    private static final BooleanProperty DOWNLOAD_WATER = new BooleanProperty("download.cadastrefr.water", false);
    private static final BooleanProperty DOWNLOAD_PARCEL = new BooleanProperty("download.cadastrefr.parcel", false);
    private static final BooleanProperty DOWNLOAD_PARCEL_NUM = new BooleanProperty("download.cadastrefr.parcelnum", false);
    private static final BooleanProperty DOWNLOAD_SECTION = new BooleanProperty("download.cadastrefr.section", false);
    private static final BooleanProperty DOWNLOAD_LOCALITY = new BooleanProperty("download.cadastrefr.locality", false);
    private static final BooleanProperty DOWNLOAD_COMMUNE = new BooleanProperty("download.cadastrefr.commune", false);

    private static JCheckBox createCheckBox(String text, BooleanProperty property, String tooltip) {
        JCheckBox cb = new JCheckBox(text, (boolean)property.get());
        cb.setOpaque(false);
        cb.setToolTipText(tooltip);
        return cb;
    }

    public CadastreDownloadSourcePanel(CadastreDownloadSource ds) {
        super((DownloadSource)ds);
        this.setBackground(BG_COLOR.get());
        this.setLayout(new GridBagLayout());
        ChangeListener checkboxChangeListener = e -> DownloadDialog.getInstance().getSelectedDownloadArea().ifPresent(this::updateSizeCheck);
        this.add(new JLabel(I18n.tr((String)"Objects:", (Object[])new Object[0])), GBC.std().insets(5, 5, 1, 5).anchor(10));
        this.cbDownloadBuilding = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"building", (Object[])new Object[0]), DOWNLOAD_BUILDING, I18n.tr((String)"Select to download buildings in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadAddress = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"address", (Object[])new Object[0]), DOWNLOAD_ADDRESS, I18n.tr((String)"Select to download addresses in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadSymbol = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"symbol", (Object[])new Object[0]), DOWNLOAD_SYMBOL, I18n.tr((String)"Select to download symbols in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadWater = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"water", (Object[])new Object[0]), DOWNLOAD_WATER, I18n.tr((String)"Select to download water bodies in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadParcel = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"parcel", (Object[])new Object[0]), DOWNLOAD_PARCEL, I18n.tr((String)"Select to download cadastral parcels in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadParcelNum = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"parcel number", (Object[])new Object[0]), DOWNLOAD_PARCEL_NUM, I18n.tr((String)"Select to download cadastral parcel numbers in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadSection = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"section", (Object[])new Object[0]), DOWNLOAD_SECTION, I18n.tr((String)"Select to download cadastral sections in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadLocality = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"locality", (Object[])new Object[0]), DOWNLOAD_LOCALITY, I18n.tr((String)"Select to download localities in the selected download area.", (Object[])new Object[0]));
        this.cbDownloadCommune = CadastreDownloadSourcePanel.createCheckBox(I18n.tr((String)"commune", (Object[])new Object[0]), DOWNLOAD_COMMUNE, I18n.tr((String)"Select to download municipality boundary in the selected download area.", (Object[])new Object[0]));
        for (JCheckBox cb : Arrays.asList(this.cbDownloadBuilding, this.cbDownloadAddress, this.cbDownloadSymbol, this.cbDownloadWater, this.cbDownloadParcel, this.cbDownloadParcelNum, this.cbDownloadSection, this.cbDownloadLocality, this.cbDownloadCommune)) {
            cb.getModel().addChangeListener(checkboxChangeListener);
            this.add(cb, GBC.std().insets(1, 5, 1, 5));
        }
        Font labelFont = this.sizeCheck.getFont();
        this.sizeCheck.setFont(labelFont.deriveFont(0, labelFont.getSize()));
        this.setMinimumSize(new Dimension(450, 115));
    }

    public CadastreDownloadData getData() {
        return new CadastreDownloadData(this.isDownloadWater(), this.isDownloadBuilding(), this.isDownloadSymbol(), this.isDownloadParcel(), this.isDownloadParcelNum(), this.isDownloadAddress(), this.isDownloadLocality(), this.isDownloadSection(), this.isDownloadCommune());
    }

    public void rememberSettings() {
        DOWNLOAD_BUILDING.put(Boolean.valueOf(this.isDownloadBuilding()));
        DOWNLOAD_ADDRESS.put(Boolean.valueOf(this.isDownloadAddress()));
        DOWNLOAD_SYMBOL.put(Boolean.valueOf(this.isDownloadSymbol()));
        DOWNLOAD_WATER.put(Boolean.valueOf(this.isDownloadWater()));
        DOWNLOAD_PARCEL.put(Boolean.valueOf(this.isDownloadParcel()));
        DOWNLOAD_PARCEL_NUM.put(Boolean.valueOf(this.isDownloadParcelNum()));
        DOWNLOAD_SECTION.put(Boolean.valueOf(this.isDownloadSection()));
        DOWNLOAD_LOCALITY.put(Boolean.valueOf(this.isDownloadLocality()));
        DOWNLOAD_COMMUNE.put(Boolean.valueOf(this.isDownloadCommune()));
    }

    public void restoreSettings() {
        this.cbDownloadBuilding.setSelected(DOWNLOAD_BUILDING.get());
        this.cbDownloadAddress.setSelected(DOWNLOAD_ADDRESS.get());
        this.cbDownloadSymbol.setSelected(DOWNLOAD_SYMBOL.get());
        this.cbDownloadWater.setSelected(DOWNLOAD_WATER.get());
        this.cbDownloadParcel.setSelected(DOWNLOAD_PARCEL.get());
        this.cbDownloadParcelNum.setSelected(DOWNLOAD_PARCEL_NUM.get());
        this.cbDownloadSection.setSelected(DOWNLOAD_SECTION.get());
        this.cbDownloadLocality.setSelected(DOWNLOAD_LOCALITY.get());
        this.cbDownloadCommune.setSelected(DOWNLOAD_COMMUNE.get());
    }

    public boolean checkDownload(DownloadSettings settings) {
        if (!settings.getDownloadBounds().isPresent()) {
            JOptionPane.showMessageDialog(this.getParent(), I18n.tr((String)"Please select a download area first.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return false;
        }
        if (!(this.isDownloadWater() || this.isDownloadBuilding() || this.isDownloadSymbol() || this.isDownloadParcel() || this.isDownloadParcelNum() || this.isDownloadAddress() || this.isDownloadLocality() || this.isDownloadSection() || this.isDownloadCommune())) {
            JOptionPane.showMessageDialog(this.getParent(), I18n.tr((String)"<html>Nothing is enabled.<br>Please choose something to download.</html>", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return false;
        }
        this.rememberSettings();
        return true;
    }

    boolean isDownloadBuilding() {
        return this.cbDownloadBuilding.isSelected();
    }

    boolean isDownloadAddress() {
        return this.cbDownloadAddress.isSelected();
    }

    boolean isDownloadSymbol() {
        return this.cbDownloadSymbol.isSelected();
    }

    boolean isDownloadWater() {
        return this.cbDownloadWater.isSelected();
    }

    boolean isDownloadParcel() {
        return this.cbDownloadParcel.isSelected();
    }

    boolean isDownloadParcelNum() {
        return this.cbDownloadParcelNum.isSelected();
    }

    boolean isDownloadSection() {
        return this.cbDownloadSection.isSelected();
    }

    boolean isDownloadLocality() {
        return this.cbDownloadLocality.isSelected();
    }

    boolean isDownloadCommune() {
        return this.cbDownloadCommune.isSelected();
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"cadastre_small");
    }

    public void boundingBoxChanged(Bounds bbox) {
        this.updateSizeCheck(bbox);
    }

    public String getSimpleName() {
        return SIMPLE_NAME;
    }

    private void updateSizeCheck(Bounds bbox) {
        if (bbox == null) {
            this.sizeCheck.setText(I18n.tr((String)"No area selected yet", (Object[])new Object[0]));
            this.sizeCheck.setForeground(Color.darkGray);
            return;
        }
    }

    private void displaySizeCheckResult(boolean isAreaTooLarge) {
        if (isAreaTooLarge) {
            this.sizeCheck.setText(I18n.tr((String)"Download area too large; will probably be rejected by server", (Object[])new Object[0]));
            this.sizeCheck.setForeground(Color.red);
        } else {
            this.sizeCheck.setText(I18n.tr((String)"Download area ok, size probably acceptable to server", (Object[])new Object[0]));
            this.sizeCheck.setForeground(Color.darkGray);
        }
    }
}

