/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;
import relcontext.actions.SortAndFixAction;

public class AddRemoveMemberAction
extends JosmAction
implements ChosenRelationListener {
    private ChosenRelation rel;
    private SortAndFixAction sortAndFix;

    public AddRemoveMemberAction(ChosenRelation rel, SortAndFixAction sortAndFix) {
        super(null, "relcontext/addremove", I18n.tr((String)"Add/remove members from the chosen relation", (Object[])new Object[0]), Shortcut.registerShortcut((String)"reltoolbox:addremove", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Add/remove members from the chosen relation", (Object[])new Object[0])}), (int)61, (int)5003), false);
        this.rel = rel;
        this.sortAndFix = sortAndFix;
        rel.addChosenRelationListener(this);
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent e) {
        Command roleFix;
        if (this.rel.get() == null) {
            return;
        }
        Relation r = new Relation(this.rel.get());
        ArrayList toAdd = new ArrayList(this.getLayerManager().getEditDataSet().getSelected());
        toAdd.remove(this.rel.get());
        toAdd.removeAll(r.getMemberPrimitives());
        boolean isBroken = !toAdd.isEmpty() && this.sortAndFix.needsFixing(r);
        r.removeMembersFor(this.getLayerManager().getEditDataSet().getSelected());
        for (OsmPrimitive p : toAdd) {
            int pos = -1;
            if (pos < 0) {
                r.addMember(new RelationMember("", p));
                continue;
            }
            r.addMember(pos, new RelationMember("", p));
        }
        Command command = roleFix = !isBroken && this.sortAndFix.needsFixing(r) ? this.sortAndFix.fixRelation(r) : null;
        if (roleFix != null) {
            roleFix.executeCommand();
        }
        if (!r.getMemberPrimitives().equals(this.rel.get().getMemberPrimitives())) {
            UndoRedoHandler.getInstance().add((Command)new ChangeCommand((OsmPrimitive)this.rel.get(), (OsmPrimitive)r));
        }
    }

    protected int findAdjacentMember(Way w, Relation r) {
        Node firstNode = w.firstNode();
        Node lastNode = w.lastNode();
        if (firstNode != null && !firstNode.equals((Object)lastNode)) {
            for (int i = 0; i < r.getMembersCount(); ++i) {
                if (!r.getMember(i).getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                Way rw = (Way)r.getMember(i).getMember();
                Node firstNodeR = rw.firstNode();
                Node lastNodeR = rw.lastNode();
                if (!firstNode.equals((Object)firstNodeR) && !firstNode.equals((Object)lastNodeR) && !lastNode.equals((Object)firstNodeR) && !lastNode.equals((Object)lastNodeR)) continue;
                return i + 1;
            }
        }
        return -1;
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        this.updateEnabledState(this.getLayerManager().getEditDataSet() == null ? null : this.getLayerManager().getEditDataSet().getSelected());
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateIcon();
        if (this.rel == null || this.rel.get() == null || selection == null || selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (selection.size() == 1 && selection.contains(this.rel.get())) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    protected void updateIcon() {
        int state;
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null || ds.getSelected() == null || ds.getSelected().isEmpty() || this.rel == null || this.rel.get() == null) {
            state = 0;
        } else {
            ArrayList toAdd = new ArrayList(ds.getSelected());
            toAdd.remove(this.rel.get());
            int selectedSize = toAdd.size();
            if (selectedSize == 0) {
                state = 0;
            } else {
                toAdd.removeAll(this.rel.get().getMemberPrimitives());
                state = toAdd.isEmpty() ? 2 : (toAdd.size() < selectedSize ? 3 : 1);
            }
        }
        GuiHelper.runInEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                if (state == 0) {
                    AddRemoveMemberAction.this.putValue("SwingLargeIconKey", ImageProvider.get((String)"relcontext", (String)"addremove"));
                } else {
                    String iconName = state == 1 ? "add" : (state == 2 ? "remove" : "addremove");
                    AddRemoveMemberAction.this.putValue("Name", null);
                    AddRemoveMemberAction.this.putValue("SwingLargeIconKey", ImageProvider.get((String)"relcontext", (String)iconName));
                }
            }
        });
    }
}

