/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;

final class DecimalQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 6504081836032983882L;
    private final BigDecimal value;

    public DecimalQuantity(BigDecimal value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return unit.equals(unit) ? this.value.doubleValue() : unit.getConverterTo(unit).convert(this.value.doubleValue());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        return super.getUnit().equals(unit) ? this.value : ((AbstractConverter)unit.getConverterTo(unit)).convert(this.value, ctx);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.add(AbstractQuantity.Equalizer.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit());
        }
        Quantity<Q> converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.add(AbstractQuantity.Equalizer.toBigDecimal(converted.getValue())), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.subtract(AbstractQuantity.Equalizer.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit());
        }
        Quantity<Q> converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.subtract(AbstractQuantity.Equalizer.toBigDecimal(converted.getValue()), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new DecimalQuantity(this.value.multiply(AbstractQuantity.Equalizer.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value.multiply(AbstractQuantity.Equalizer.toBigDecimal(that), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value.divide(AbstractQuantity.Equalizer.toBigDecimal(that), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigDecimal.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new DecimalQuantity(this.value.divide(AbstractQuantity.Equalizer.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

