/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class KeySortedList<K extends Comparable<K>, V>
extends AbstractSequentialList<V>
implements Serializable {
    private static final long serialVersionUID = 6969483179756527012L;
    private final SortedMap<K, List<V>> map;

    public KeySortedList() {
        this.map = new TreeMap<K, List<V>>();
    }

    private KeySortedList(SortedMap<K, List<V>> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        int count = 0;
        for (List<V> list : this.map.values()) {
            count += list.size();
        }
        return count;
    }

    public void add(K key, V element) {
        ArrayList<V> values = (ArrayList<V>)this.map.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            this.map.put(key, values);
        }
        values.add(element);
    }

    public int removeAll(K key) {
        List values = (List)this.map.remove(key);
        return values != null ? values.size() : 0;
    }

    public int count(K key) {
        List values = (List)this.map.get(key);
        return values != null ? values.size() : 0;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public V first(K key) throws NoSuchElementException {
        List values = (List)this.map.get(key);
        if (values == null || values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (V)values.get(0);
    }

    public V last(K key) throws NoSuchElementException {
        List values = (List)this.map.get(key);
        if (values == null || values.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (V)values.get(values.size() - 1);
    }

    public ListIterator<V> listIterator(K fromKey) {
        return new Iter(this, fromKey);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return new Iter(this, index);
    }

    public KeySortedList<K, V> headList(K toKey) {
        return new KeySortedList<K, V>(this.map.headMap(toKey));
    }

    public KeySortedList<K, V> tailList(K fromKey) {
        return new KeySortedList<K, V>(this.map.tailMap(fromKey));
    }

    private static final class Iter
    implements ListIterator<V> {
        private Iterator<Map.Entry<K, List<V>>> entriesIter;
        private K key;
        private List<V> values;
        private ListIterator<V> valuesIter;
        private int base;
        final /* synthetic */ KeySortedList this$0;

        public Iter(K fromKey) {
            this.this$0 = var1_1;
            for (Map.Entry entry : ((KeySortedList)var1_1).map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = entry.getValue();
                if (fromKey.compareTo(this.key) <= 0) {
                    this.valuesIter = this.values.listIterator();
                    assert (this.equals(new Iter(var1_1, this.base)));
                    return;
                }
                this.base += this.values.size();
            }
            this.key = null;
            this.values = Collections.emptyList();
            this.valuesIter = this.values.listIterator();
        }

        public Iter(KeySortedList keySortedList, int index) {
            this.this$0 = keySortedList;
            for (Map.Entry entry : keySortedList.map.entrySet()) {
                this.key = (Comparable)entry.getKey();
                this.values = entry.getValue();
                int size = this.values.size();
                if (index < size) {
                    this.valuesIter = this.values.listIterator(index);
                    return;
                }
                index -= size;
                this.base += size;
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.key = null;
            this.values = Collections.emptyList();
            this.valuesIter = this.values.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.valuesIter.hasNext() || this.entriesIter.hasNext();
        }

        @Override
        public V next() {
            while (!this.valuesIter.hasNext()) {
                if (this.entriesIter.hasNext()) {
                    Map.Entry entry = this.entriesIter.next();
                    this.base += this.values.size();
                    this.key = (Comparable)entry.getKey();
                    this.values = entry.getValue();
                    this.valuesIter = this.values.listIterator();
                    continue;
                }
                this.key = null;
                this.values = Collections.emptyList();
                this.valuesIter = this.values.listIterator();
                break;
            }
            return this.valuesIter.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.valuesIter.hasPrevious() || this.base != 0;
        }

        @Override
        public V previous() {
            while (!this.valuesIter.hasPrevious() && this.base != 0) {
                this.key = (Comparable)this.this$0.map.headMap(this.key).lastKey();
                this.entriesIter = this.this$0.map.tailMap(this.key).entrySet().iterator();
                Map.Entry entry = this.entriesIter.next();
                assert (this.key == entry.getKey()) : this.key;
                this.values = entry.getValue();
                int size = this.values.size();
                this.valuesIter = this.values.listIterator(Math.max(size - 1, 0));
                this.base -= size;
                assert (this.base >= 0) : this.base;
            }
            return this.valuesIter.previous();
        }

        @Override
        public int nextIndex() {
            return this.base + this.valuesIter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.base + this.valuesIter.previousIndex();
        }

        @Override
        public void remove() {
            this.valuesIter.remove();
        }

        @Override
        public void set(V o) {
            this.valuesIter.set(o);
        }

        @Override
        public void add(V o) {
            this.valuesIter.add(o);
        }

        private boolean equals(Iter that) {
            return this.key == that.key && this.values == that.values && this.base == that.base && this.valuesIter.nextIndex() == that.valuesIter.nextIndex();
        }
    }
}

