/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.Arrays;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.util.XArray;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;

public class DimensionFilter {
    public static final Hints.Key INSTANCE = new Hints.Key(DimensionFilter.class);
    private int[] sourceDimensions;
    private int[] targetDimensions;
    private final MathTransformFactory factory;

    public DimensionFilter() {
        this(ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public DimensionFilter(Hints hints) {
        this(ReferencingFactoryFinder.getMathTransformFactory(hints));
    }

    public DimensionFilter(MathTransformFactory factory) {
        this.factory = factory;
    }

    public static DimensionFilter getInstance(Hints hints) {
        DimensionFilter candidate;
        if (hints != null && (candidate = (DimensionFilter)hints.get(INSTANCE)) != null) {
            candidate.clear();
            return candidate;
        }
        return new DimensionFilter(hints);
    }

    public void clear() {
        this.sourceDimensions = null;
        this.targetDimensions = null;
    }

    public void addSourceDimension(int dimension) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, dimension);
    }

    public void addSourceDimensions(int[] dimensions) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, dimensions);
    }

    public void addSourceDimensionRange(int lower, int upper) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, lower, upper);
    }

    public int[] getSourceDimensions() throws IllegalStateException {
        if (this.sourceDimensions != null) {
            return (int[])this.sourceDimensions.clone();
        }
        throw new IllegalStateException();
    }

    public void addTargetDimension(int dimension) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, dimension);
    }

    public void addTargetDimensions(int[] dimensions) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, dimensions);
    }

    public void addTargetDimensionRange(int lower, int upper) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, lower, upper);
    }

    public int[] getTargetDimensions() throws IllegalStateException {
        if (this.targetDimensions != null) {
            return (int[])this.targetDimensions.clone();
        }
        throw new IllegalStateException();
    }

    public MathTransform separate(MathTransform transform) throws FactoryException {
        if (this.sourceDimensions == null) {
            this.sourceDimensions = DimensionFilter.series(0, transform.getSourceDimensions());
            if (this.targetDimensions == null) {
                this.targetDimensions = DimensionFilter.series(0, transform.getTargetDimensions());
                return transform;
            }
            return this.separateOutput(transform);
        }
        int[] target = this.targetDimensions;
        transform = this.separateInput(transform);
        assert (XArray.isStrictlySorted(this.targetDimensions));
        if (target != null) {
            int[] step = this.targetDimensions;
            this.targetDimensions = new int[target.length];
            for (int i = 0; i < target.length; ++i) {
                int j = Arrays.binarySearch(step, target[i]);
                if (j < 0) {
                    throw new FactoryException(Errors.format(81));
                }
                this.targetDimensions[i] = j;
            }
            transform = this.separateOutput(transform);
            this.targetDimensions = target;
        }
        assert (this.sourceDimensions.length == transform.getSourceDimensions()) : transform;
        assert (this.targetDimensions.length == transform.getTargetDimensions()) : transform;
        return transform;
    }

    private MathTransform separateInput(MathTransform transform) throws FactoryException {
        int dimSource = transform.getSourceDimensions();
        int dimTarget = transform.getTargetDimensions();
        int dimInput = this.sourceDimensions.length;
        int lower = this.sourceDimensions[0];
        int upper = this.sourceDimensions[dimInput - 1] + 1;
        assert (XArray.isStrictlySorted(this.sourceDimensions));
        if (upper > dimSource) {
            throw new IllegalArgumentException(Errors.format(58, "sourceDimensions", upper - 1));
        }
        if (dimInput == dimSource) {
            assert (lower == 0 && upper == dimSource);
            this.targetDimensions = DimensionFilter.series(0, dimTarget);
            return transform;
        }
        if (transform.isIdentity()) {
            this.targetDimensions = this.sourceDimensions;
            return this.factory.createAffineTransform(MatrixFactory.create(dimInput + 1));
        }
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform ctr = (ConcatenatedTransform)transform;
            int[] original = this.sourceDimensions;
            MathTransform step1 = this.separateInput(ctr.transform1);
            this.sourceDimensions = this.targetDimensions;
            MathTransform step2 = this.separateInput(ctr.transform2);
            this.sourceDimensions = original;
            return this.factory.createConcatenatedTransform(step1, step2);
        }
        if (transform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)transform;
            int dimPass = passThrough.subTransform.getSourceDimensions();
            int dimDiff = passThrough.subTransform.getTargetDimensions() - dimPass;
            int subLower = passThrough.firstAffectedOrdinate;
            int subUpper = subLower + dimPass;
            DimensionFilter subFilter = new DimensionFilter(this.factory);
            for (int i = 0; i < this.sourceDimensions.length; ++i) {
                int n = this.sourceDimensions[i];
                if (n >= subLower && n < subUpper) {
                    subFilter.addSourceDimension(n - subLower);
                    continue;
                }
                if (n >= subUpper) {
                    n += dimDiff;
                }
                this.targetDimensions = DimensionFilter.add(this.targetDimensions, n);
            }
            if (subFilter.sourceDimensions == null) {
                return this.factory.createAffineTransform(MatrixFactory.create(dimInput + 1));
            }
            MathTransform subTransform = subFilter.separateInput(passThrough.subTransform);
            int i = 0;
            while (i < subFilter.targetDimensions.length) {
                int n = i++;
                subFilter.targetDimensions[n] = subFilter.targetDimensions[n] + subLower;
            }
            this.targetDimensions = DimensionFilter.add(this.targetDimensions, subFilter.targetDimensions);
            if (DimensionFilter.containsAll(this.sourceDimensions, lower, subLower) && DimensionFilter.containsAll(this.sourceDimensions, subUpper, upper)) {
                int firstAffectedOrdinate = Math.max(0, subLower - lower);
                int numTrailingOrdinates = Math.max(0, upper - subUpper);
                return this.factory.createPassThroughTransform(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
            }
            this.targetDimensions = null;
        }
        if (transform instanceof LinearTransform) {
            int nRows = 0;
            boolean hasLastRow = false;
            Matrix matrix = ((LinearTransform)transform).getMatrix();
            assert (dimSource + 1 == matrix.getNumCol() && dimTarget + 1 == matrix.getNumRow()) : matrix;
            Object rows = new double[dimTarget + 1][];
            block2: for (int j = 0; j < ((double[][])rows).length; ++j) {
                double[] row = new double[dimInput + 1];
                int nCols = 0;
                int scan = 0;
                for (int i = 0; i < dimSource; ++i) {
                    double element = matrix.getElement(j, i);
                    if (scan < this.sourceDimensions.length && this.sourceDimensions[scan] == i) {
                        row[nCols++] = element;
                        ++scan;
                        continue;
                    }
                    if (element != 0.0) continue block2;
                }
                row[nCols++] = matrix.getElement(j, dimSource);
                assert (nCols == row.length) : nCols;
                if (j == dimTarget) {
                    hasLastRow = true;
                } else {
                    this.targetDimensions = DimensionFilter.add(this.targetDimensions, j);
                }
                rows[nRows++] = row;
            }
            rows = (double[][])XArray.resize(rows, nRows);
            if (hasLastRow) {
                return this.factory.createAffineTransform(new GeneralMatrix((double[][])rows));
            }
        }
        throw new FactoryException(Errors.format(81));
    }

    private MathTransform separateOutput(MathTransform transform) throws FactoryException {
        int dimSource = transform.getSourceDimensions();
        int dimTarget = transform.getTargetDimensions();
        int dimOutput = this.targetDimensions.length;
        int lower = this.targetDimensions[0];
        int upper = this.targetDimensions[dimOutput - 1];
        assert (XArray.isStrictlySorted(this.targetDimensions));
        if (upper > dimTarget) {
            throw new IllegalArgumentException(Errors.format(58, "targetDimensions", upper));
        }
        if (dimOutput == dimTarget) {
            assert (lower == 0 && upper == dimTarget);
            return transform;
        }
        int dimPass = 0;
        int dimDiff = 0;
        int dimStep = dimTarget;
        if (transform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)transform;
            int subLower = passThrough.firstAffectedOrdinate;
            int subUpper = subLower + passThrough.subTransform.getTargetDimensions();
            if (!DimensionFilter.containsAny(this.targetDimensions, subLower, subUpper)) {
                transform = null;
                dimStep = dimSource;
                dimPass = subLower;
                dimDiff = subLower + passThrough.subTransform.getSourceDimensions() - subUpper;
            }
        }
        XMatrix matrix = MatrixFactory.create(dimOutput + 1, dimStep + 1);
        matrix.setZero();
        for (int j = 0; j < dimOutput; ++j) {
            int i = this.targetDimensions[j];
            if (i >= dimPass) {
                i += dimDiff;
            }
            matrix.setElement(j, i, 1.0);
        }
        matrix.setElement(dimOutput, dimStep, 1.0);
        MathTransform filtered = this.factory.createAffineTransform(matrix);
        if (transform != null) {
            filtered = this.factory.createConcatenatedTransform(transform, filtered);
        }
        return filtered;
    }

    private static boolean containsAll(int[] sequence, int lower, int upper) {
        if (lower == upper) {
            return true;
        }
        if (sequence != null) {
            assert (XArray.isStrictlySorted(sequence));
            int index = Arrays.binarySearch(sequence, lower);
            if (index >= 0 && (index += --upper - lower) >= 0 && index < sequence.length) {
                return sequence[index] == upper;
            }
        }
        return false;
    }

    private static boolean containsAny(int[] sequence, int lower, int upper) {
        if (upper == lower) {
            return true;
        }
        if (sequence != null) {
            assert (XArray.isStrictlySorted(sequence));
            int index = Arrays.binarySearch(sequence, lower);
            if (index >= 0) {
                return true;
            }
            return (index ^= 0xFFFFFFFF) < sequence.length && sequence[index] < upper;
        }
        return false;
    }

    private static int[] add(int[] sequence, int dimension) throws IllegalArgumentException {
        if (dimension < 0) {
            throw new IllegalArgumentException(Errors.format(58, "dimension", dimension));
        }
        if (sequence == null) {
            return new int[]{dimension};
        }
        assert (XArray.isStrictlySorted(sequence));
        int i = Arrays.binarySearch(sequence, dimension);
        if (i < 0) {
            sequence = XArray.insert(sequence, i ^= 0xFFFFFFFF, 1);
            sequence[i] = dimension;
        }
        assert (Arrays.binarySearch(sequence, dimension) == i);
        return sequence;
    }

    private static int[] add(int[] sequence, int[] dimensions) throws IllegalArgumentException {
        if (dimensions.length != 0) {
            DimensionFilter.ensureValidSeries(dimensions);
            if (sequence == null) {
                sequence = (int[])dimensions.clone();
            } else {
                for (int i = 0; i < dimensions.length; ++i) {
                    sequence = DimensionFilter.add(sequence, dimensions[i]);
                }
            }
        }
        return sequence;
    }

    private static int[] add(int[] sequence, int lower, int upper) throws IllegalArgumentException {
        if (lower < 0 || lower >= upper) {
            throw new IllegalArgumentException(Errors.format(58, "lower", lower));
        }
        if (sequence == null) {
            sequence = DimensionFilter.series(lower, upper);
        } else {
            while (lower < upper) {
                sequence = DimensionFilter.add(sequence, lower++);
            }
        }
        assert (DimensionFilter.containsAll(sequence, lower, upper));
        return sequence;
    }

    private static int[] series(int lower, int upper) throws IllegalArgumentException {
        int[] sequence = new int[upper - lower];
        for (int i = 0; i < sequence.length; ++i) {
            sequence[i] = i + lower;
        }
        return sequence;
    }

    private static void ensureValidSeries(int[] dimensions) throws IllegalArgumentException {
        int last = -1;
        for (int i = 0; i < dimensions.length; ++i) {
            int value = dimensions[i];
            if (value <= last) {
                throw new IllegalArgumentException(Errors.format(58, "dimensions[" + i + ']', value));
            }
            last = value;
        }
    }
}

