/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.string;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.FunctionImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class ConcatenateFunction
extends FunctionImpl {
    static final Logger LOGGER = Logging.getLogger(ConcatenateFunction.class);
    public static final FunctionName NAME = ConcatenateFunction.functionName("Concatenate", "result:String", "text:String:2,");

    public ConcatenateFunction() {
        this.functionName = NAME;
    }

    @Override
    public String getName() {
        return NAME.getName();
    }

    public int getArgCount() {
        return NAME.getArgumentCount();
    }

    @Override
    public Object evaluate(Object feature) {
        StringBuffer text = new StringBuffer();
        for (Expression expression : this.getParameters()) {
            try {
                String str = expression.evaluate(feature, String.class);
                if (str == null) continue;
                text.append(str);
            }
            catch (Exception couldNotCompute) {
                LOGGER.log(Level.FINE, "Failed to concatenate string in Concatenate function", couldNotCompute);
            }
        }
        return text.toString();
    }
}

