/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.filter.BinaryLogicAbstract;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;

public abstract class LogicFilterImpl
extends BinaryLogicAbstract {
    int cachedHash = 0;

    protected LogicFilterImpl(List<Filter> children) {
        super(children);
    }

    protected LogicFilterImpl(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        this(new ArrayList<Filter>());
        this.children.add(filter1);
        this.addFilter(filter2);
    }

    public final void addFilter(Filter filter) throws IllegalFilterException {
        this.cachedHash = 0;
        if (this instanceof Not && this.children.size() != 0) {
            throw new IllegalFilterException("Attempted to add an more than one filter to a NOT filter.");
        }
        this.children.add(filter);
    }

    public Iterator getFilterIterator() {
        return this.children.iterator();
    }

    public String toString() {
        String returnString = "[";
        String operator = "";
        Iterator iterator = this.children.iterator();
        if (this instanceof Or) {
            operator = " OR ";
        } else if (this instanceof And) {
            operator = " AND ";
        } else if (this instanceof Not) {
            return "[ NOT " + iterator.next().toString() + " ]";
        }
        while (iterator.hasNext()) {
            returnString = returnString + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            returnString = returnString + operator;
        }
        return returnString + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        if (this.cachedHash == 0) {
            int result = 17;
            result = 37 * result + this.getClass().hashCode();
            this.cachedHash = result = 37 * result + this.children.hashCode();
        }
        return this.cachedHash;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

