/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseScaleOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.jai.Registry;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Scale
extends BaseScaleOperationJAI {
    private static final long serialVersionUID = -3212656385631097713L;
    private static final int[] lock = new int[1];

    public Scale() {
        super("Scale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RenderedImage createRenderedImage(ParameterBlockJAI parameters, RenderingHints hints) {
        PlanarImage image;
        RenderedImage source = (RenderedImage)parameters.getSource(0);
        Interpolation interpolation = parameters.getObjectParameter("interpolation") != null ? (Interpolation)parameters.getObjectParameter("interpolation") : (hints.get(JAI.KEY_INTERPOLATION) != null ? (Interpolation)hints.get(JAI.KEY_INTERPOLATION) : null);
        int transferType = source.getSampleModel().getDataType();
        JAI processor = OperationJAI.getJAI(hints);
        if (!(interpolation == null || interpolation instanceof InterpolationNearest || transferType != 4 && transferType != 5)) {
            int[] nArray = lock;
            synchronized (lock) {
                Registry.setNativeAccelerationAllowed(this.getName(), false);
                image = processor.createNS(this.getName(), parameters, hints).getRendering();
                Registry.setNativeAccelerationAllowed(this.getName(), true);
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        } else {
            image = processor.createNS(this.getName(), parameters, hints);
        }
        return image;
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)parameters2.parameter("source0").getValue();
        Scale.handleROINoDataInternal(parameters, source, "Scale", 5, 7);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        Object bkgProp;
        Map props = sources[0].getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (props != null) {
            properties.putAll(props);
        }
        if (parameters.parameters.getNumParameters() > 5 && parameters.parameters.getObjectParameter(8) != null && (bkgProp = parameters.parameters.getObjectParameter(8)) != null && bkgProp instanceof double[]) {
            double[] background = (double[])bkgProp;
            CoverageUtilities.setNoDataProperty(properties, background);
        }
        if (data instanceof RenderedOp) {
            Object roiProp;
            String operationName = ((RenderedOp)data).getOperationName();
            PropertyGenerator propertyGenerator = null;
            if (operationName.equalsIgnoreCase("Scale") || operationName.equalsIgnoreCase("Translate")) {
                propertyGenerator = Scale.getOperationDescriptor(operationName).getPropertyGenerators("rendered")[0];
            }
            if (propertyGenerator != null && (roiProp = propertyGenerator.getProperty("roi", data)) != null && roiProp instanceof ROI) {
                CoverageUtilities.setROIProperty(properties, (ROI)roiProp);
            }
        }
        return properties;
    }
}

