/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.undelete;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.undelete.UndeleteDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class UndeleteAction
extends JosmAction {
    public UndeleteAction() {
        super(I18n.tr((String)"Undelete object...", (Object[])new Object[0]), "undelete", I18n.tr((String)"Undelete object by id", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:undelete", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Undelete object...", (Object[])new Object[0])}), (int)85, (int)5007), true);
    }

    public void actionPerformed(ActionEvent e) {
        UndeleteDialog dialog = new UndeleteDialog((Component)MainApplication.getMainFrame());
        if (dialog.showDialog().getValue() != 1) {
            return;
        }
        Config.getPref().putBoolean("undelete.newlayer", dialog.isNewLayerSelected());
        Config.getPref().put("undelete.osmid", dialog.getOsmIdsString());
        this.undelete(dialog.isNewLayerSelected(), dialog.getOsmIds(), null);
    }

    public void undelete(boolean newLayer, List<PrimitiveId> ids, OsmPrimitive parent) {
        this.undelete(newLayer, ids, parent, new LinkedHashSet<OsmPrimitive>());
    }

    private void undelete(boolean newLayer, List<PrimitiveId> ids, OsmPrimitive parent, Set<OsmPrimitive> restored) {
        Logging.info((String)("Undeleting " + ids + (parent == null ? "" : " with parent " + parent)));
        OsmDataLayer tmpLayer = MainApplication.getLayerManager().getEditLayer();
        if (tmpLayer == null || newLayer) {
            tmpLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            MainApplication.getLayerManager().addLayer((Layer)tmpLayer);
        }
        OsmDataLayer layer = tmpLayer;
        HistoryLoadTask task = new HistoryLoadTask();
        task.setChangesetDataNeeded(false);
        for (PrimitiveId id : ids) {
            task.add(id);
        }
        MainApplication.worker.execute((Runnable)task);
        MainApplication.worker.submit(new Worker(parent, layer, ids, restored));
    }

    private final class Worker
    implements Runnable {
        private final OsmPrimitive parent;
        private final OsmDataLayer layer;
        private final List<PrimitiveId> ids;
        private Set<OsmPrimitive> restored;

        private Worker(OsmPrimitive parent, OsmDataLayer layer, List<PrimitiveId> ids, Set<OsmPrimitive> restored) {
            this.parent = parent;
            this.layer = layer;
            this.ids = ids;
            this.restored = restored != null ? restored : new LinkedHashSet();
        }

        @Override
        public void run() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (PrimitiveId pid : this.ids) {
                OsmPrimitive primitive = this.layer.data.getPrimitiveById(pid);
                if (primitive == null) {
                    try {
                        Long id = pid.getUniqueId();
                        OsmPrimitiveType type = pid.getType();
                        History h = HistoryDataSet.getInstance().getHistory(id.longValue(), type);
                        if (h == null) {
                            Logging.warn((String)("Cannot find history for " + type + " " + id));
                            return;
                        }
                        HistoryOsmPrimitive hPrimitive1 = h.getLatest();
                        HistoryOsmPrimitive hPrimitive2 = null;
                        boolean visible = hPrimitive1.isVisible();
                        if (visible) {
                            if (type == OsmPrimitiveType.NODE) {
                                primitive = new Node(hPrimitive1.getId());
                                HistoryNode hNode = (HistoryNode)hPrimitive1;
                                primitive.load((PrimitiveData)hNode.fillPrimitiveData(new NodeData()));
                                this.layer.data.addPrimitive(primitive);
                            } else {
                                DownloadPrimitivesTask download = new DownloadPrimitivesTask(this.layer, Collections.singletonList(pid), true);
                                download.setZoom(false);
                                download.run();
                                primitive = (OsmPrimitive)this.layer.data.getPrimitiveById(id.longValue(), type);
                            }
                            this.restored.add(primitive);
                        } else {
                            long idx = 1L;
                            long n = hPrimitive1.getVersion();
                            while (hPrimitive2 == null && idx < n) {
                                hPrimitive2 = h.getByVersion(n - idx++);
                            }
                            if (type == OsmPrimitiveType.NODE) {
                                Node node = new Node(id.longValue(), (int)hPrimitive1.getVersion());
                                HistoryNode hNode = (HistoryNode)hPrimitive2;
                                if (hNode != null) {
                                    node.setCoor(hNode.getCoords());
                                }
                                primitive = node;
                            } else if (type == OsmPrimitiveType.WAY) {
                                hPrimitive1 = h.getLatest();
                                Way way = new Way(id.longValue(), (int)hPrimitive1.getVersion());
                                HistoryWay hWay = (HistoryWay)hPrimitive2;
                                ArrayList<SimplePrimitiveId> nodeIds = new ArrayList<SimplePrimitiveId>();
                                if (hWay != null) {
                                    for (Long i : hWay.getNodes()) {
                                        nodeIds.add(new SimplePrimitiveId(i.longValue(), OsmPrimitiveType.NODE));
                                    }
                                }
                                UndeleteAction.this.undelete(false, nodeIds, (OsmPrimitive)way, this.restored);
                                primitive = way;
                            } else {
                                primitive = new Relation();
                                hPrimitive1 = h.getLatest();
                                Relation rel = new Relation(id.longValue(), (int)hPrimitive1.getVersion());
                                HistoryRelation hRel = (HistoryRelation)hPrimitive2;
                                if (hRel != null) {
                                    ArrayList<RelationMember> members = new ArrayList<RelationMember>(hRel.getNumMembers());
                                    for (RelationMemberData m : hRel.getMembers()) {
                                        OsmPrimitive p = (OsmPrimitive)this.layer.data.getPrimitiveById(m.getMemberId(), m.getMemberType());
                                        if (p == null) {
                                            switch (m.getMemberType()) {
                                                case NODE: {
                                                    p = new Node(m.getMemberId());
                                                    break;
                                                }
                                                case CLOSEDWAY: 
                                                case WAY: {
                                                    p = new Way(m.getMemberId());
                                                    break;
                                                }
                                                case MULTIPOLYGON: 
                                                case RELATION: {
                                                    p = new Relation(m.getMemberId());
                                                }
                                            }
                                            this.layer.data.addPrimitive(p);
                                            this.restored.add(p);
                                        }
                                        members.add(new RelationMember(m.getRole(), p));
                                    }
                                    rel.setMembers(members);
                                }
                                primitive = rel;
                            }
                            if (hPrimitive2 != null) {
                                primitive.setChangesetId((int)hPrimitive1.getChangesetId());
                                primitive.setTimestamp(hPrimitive1.getTimestamp());
                                primitive.setUser(hPrimitive1.getUser());
                                primitive.setVisible(hPrimitive1.isVisible());
                                primitive.setKeys(hPrimitive2.getTags());
                                primitive.setModified(true);
                                this.layer.data.addPrimitive(primitive);
                                this.restored.add(primitive);
                            } else {
                                String msg = OsmPrimitiveType.NODE == type ? I18n.tr((String)"Unable to undelete node {0}. Object has likely been redacted", (Object[])new Object[]{id}) : (OsmPrimitiveType.WAY == type ? I18n.tr((String)"Unable to undelete way {0}. Object has likely been redacted", (Object[])new Object[]{id}) : (OsmPrimitiveType.RELATION == type ? I18n.tr((String)"Unable to undelete relation {0}. Object has likely been redacted", (Object[])new Object[]{id}) : null));
                                GuiHelper.runInEDT(() -> new Notification(msg).setIcon(2).show());
                                Logging.warn((String)msg);
                            }
                        }
                    }
                    catch (Exception e) {
                        Logging.error((Throwable)e);
                    }
                }
                if (this.parent == null || !(primitive instanceof Node)) continue;
                nodes.add((Node)primitive);
            }
            if (this.parent instanceof Way && !nodes.isEmpty()) {
                ((Way)this.parent).setNodes(nodes);
            }
            if (!this.restored.isEmpty()) {
                GuiHelper.runInEDT(() -> {
                    this.layer.data.setSelected(this.restored);
                    AutoScaleAction.autoScale((AutoScaleAction.AutoScaleMode)AutoScaleAction.AutoScaleMode.SELECTION);
                });
            }
        }
    }
}

