/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    public static Object invokeMethod(Object object, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean bl, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, bl, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, bl, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2;
        classArray = ArrayUtils.nullToEmpty(classArray);
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Method method = null;
        if (bl) {
            string2 = "No such method: ";
            method = MethodUtils.getMatchingMethod(object.getClass(), string, classArray);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            string2 = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray);
        }
        if (method == null) {
            throw new NoSuchMethodException(string2 + string + "() on object: " + object.getClass().getName());
        }
        objectArray = MethodUtils.toVarArgs(method, objectArray);
        return method.invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, false, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        classArray = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Method method = MethodUtils.getAccessibleMethod(clazz, string, classArray = ArrayUtils.nullToEmpty(classArray));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray = ArrayUtils.nullToEmpty(classArray));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        objectArray = MethodUtils.toVarArgs(method, objectArray);
        return method.invoke(null, objectArray);
    }

    private static Object[] toVarArgs(Method method, Object[] objectArray) {
        if (method.isVarArgs()) {
            Class<?>[] classArray = method.getParameterTypes();
            objectArray = MethodUtils.getVarArgs(objectArray, classArray);
        }
        return objectArray;
    }

    static Object[] getVarArgs(Object[] objectArray, Class<?>[] classArray) {
        if (objectArray.length == classArray.length && objectArray[objectArray.length - 1].getClass().equals(classArray[classArray.length - 1])) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, classArray.length - 1);
        Class<?> clazz = classArray[classArray.length - 1].getComponentType();
        int n = objectArray.length - classArray.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n);
        System.arraycopy(objectArray, classArray.length - 1, object, 0, n);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[classArray.length - 1] = object;
        return objectArray2;
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2;
            for (Class<?> clazz2 : classArray2 = clazz.getInterfaces()) {
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz2, string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            Method method = null;
            Method[] methodArray = clazz.getMethods();
            for (Method object2 : methodArray) {
                if (!object2.getName().equals(string) || !MemberUtils.isMatchingMethod(object2, classArray) || (object = MethodUtils.getAccessibleMethod(object2)) == null || method != null && MemberUtils.compareMethodFit((Method)object, method, classArray) >= 0) continue;
                method = object;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            if (method != null && method.isVarArgs() && method.getParameterTypes().length > 0 && classArray.length > 0) {
                GenericDeclaration[] genericDeclarationArray = method.getParameterTypes();
                Class<?> clazz2 = ((Class)genericDeclarationArray[genericDeclarationArray.length - 1]).getComponentType();
                String string2 = ClassUtils.primitiveToWrapper(clazz2).getName();
                String string3 = classArray[classArray.length - 1].getName();
                object = classArray[classArray.length - 1].getSuperclass().getName();
                if (!string2.equals(string3) && !string2.equals(object)) {
                    return null;
                }
            }
            return method;
        }
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Validate.notNull(clazz, "Null class not allowed.", new Object[0]);
        Validate.notEmpty(string, "Null or blank methodName not allowed.", new Object[0]);
        Method[] methodArray = clazz.getDeclaredMethods();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(clazz);
        for (Class<?> methodArray2 : list) {
            methodArray = ArrayUtils.addAll(methodArray, methodArray2.getDeclaredMethods());
        }
        Object object = null;
        for (Method method : methodArray) {
            if (string.equals(method.getName()) && Objects.deepEquals(classArray, method.getParameterTypes())) {
                return method;
            }
            if (!string.equals(method.getName()) || !ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)) continue;
            if (object == null) {
                object = method;
                continue;
            }
            if (MethodUtils.distance(classArray, method.getParameterTypes()) >= MethodUtils.distance(classArray, ((Method)object).getParameterTypes())) continue;
            object = method;
        }
        return object;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].equals(classArray2[i])) continue;
            if (ClassUtils.isAssignable(classArray[i], classArray2[i], true) && !ClassUtils.isAssignable(classArray[i], classArray2[i], false)) {
                ++n;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfaces) {
        Validate.notNull(method);
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        Iterator<Class<?>> iterator = ClassUtils.hierarchy(clazz, interfaces).iterator();
        iterator.next();
        block0: while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next();
            Method method2 = MethodUtils.getMatchingAccessibleMethod(clazz2, method.getName(), objectArray);
            if (method2 == null) continue;
            if (Arrays.equals(method2.getParameterTypes(), objectArray)) {
                linkedHashSet.add(method2);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, method2.getDeclaringClass());
            for (int i = 0; i < objectArray.length; ++i) {
                Type type;
                Type type2 = TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i]);
                if (!TypeUtils.equals(type2, type = TypeUtils.unrollVariables(map, method2.getGenericParameterTypes()[i]))) continue block0;
            }
            linkedHashSet.add(method2);
        }
        return linkedHashSet;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsWithAnnotation(clazz, clazz2, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2, boolean bl, boolean bl2) {
        List<Method> list = MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, bl, bl2);
        return list.toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2, boolean bl, boolean bl2) {
        Validate.isTrue(clazz != null, "The class must not be null", new Object[0]);
        Validate.isTrue(clazz2 != null, "The annotation class must not be null", new Object[0]);
        ArrayList arrayList = bl ? MethodUtils.getAllSuperclassesAndInterfaces(clazz) : new ArrayList();
        arrayList.add(0, clazz);
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        for (Class clazz3 : arrayList) {
            Method[] methodArray;
            for (Method method : methodArray = bl2 ? clazz3.getDeclaredMethods() : clazz3.getMethods()) {
                if (method.getAnnotation(clazz2) == null) continue;
                arrayList2.add(method);
            }
        }
        return arrayList2;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz, boolean bl, boolean bl2) {
        Validate.isTrue(method != null, "The method must not be null", new Object[0]);
        Validate.isTrue(clazz != null, "The annotation class must not be null", new Object[0]);
        if (!bl2 && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A a = method.getAnnotation(clazz);
        if (a == null && bl) {
            Class<?> clazz2 = method.getDeclaringClass();
            List<Class<?>> list = MethodUtils.getAllSuperclassesAndInterfaces(clazz2);
            for (Class<?> clazz3 : list) {
                Method method2;
                try {
                    method2 = bl2 ? clazz3.getDeclaredMethod(method.getName(), method.getParameterTypes()) : clazz3.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                a = method2.getAnnotation(clazz);
                if (a == null) continue;
                break;
            }
        }
        return a;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(clazz);
        int n = 0;
        List<Class<?>> list2 = ClassUtils.getAllInterfaces(clazz);
        int n2 = 0;
        while (n2 < list2.size() || n < list.size()) {
            Class<?> clazz2 = n2 >= list2.size() ? list.get(n++) : (n >= list.size() ? list2.get(n2++) : (n2 < n ? list2.get(n2++) : (n < n2 ? list.get(n++) : list2.get(n2++))));
            arrayList.add(clazz2);
        }
        return arrayList;
    }
}

