/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang3.Functions;

public class Streams {
    public static <O> FailableStream<O> stream(Stream<O> stream) {
        return new FailableStream<O>(stream);
    }

    public static class FailableStream<O> {
        private Stream<O> stream;
        private boolean terminated;

        public FailableStream(Stream<O> stream) {
            this.stream = stream;
        }

        protected void assertNotTerminated() {
            if (this.terminated) {
                throw new IllegalStateException("This stream is already terminated.");
            }
        }

        protected void makeTerminated() {
            this.assertNotTerminated();
            this.terminated = true;
        }

        public FailableStream<O> filter(Functions.FailablePredicate<O, ?> failablePredicate) {
            this.assertNotTerminated();
            this.stream = this.stream.filter(Functions.asPredicate(failablePredicate));
            return this;
        }

        public void forEach(Functions.FailableConsumer<O, ?> failableConsumer) {
            this.makeTerminated();
            this.stream().forEach(Functions.asConsumer(failableConsumer));
        }

        public <A, R> R collect(Collector<? super O, A, R> collector) {
            this.makeTerminated();
            return this.stream().collect(collector);
        }

        public <A, R> R collect(Supplier<R> supplier, BiConsumer<R, ? super O> biConsumer, BiConsumer<R, R> biConsumer2) {
            this.makeTerminated();
            return this.stream().collect(supplier, biConsumer, biConsumer2);
        }

        public O reduce(O o, BinaryOperator<O> binaryOperator) {
            this.makeTerminated();
            return this.stream().reduce(o, binaryOperator);
        }

        public <R> FailableStream<R> map(Functions.FailableFunction<O, R, ?> failableFunction) {
            this.assertNotTerminated();
            return new FailableStream<R>(this.stream.map(Functions.asFunction(failableFunction)));
        }

        public Stream<O> stream() {
            return this.stream;
        }

        public boolean allMatch(Functions.FailablePredicate<O, ?> failablePredicate) {
            this.assertNotTerminated();
            return this.stream().allMatch(Functions.asPredicate(failablePredicate));
        }

        public boolean anyMatch(Functions.FailablePredicate<O, ?> failablePredicate) {
            this.assertNotTerminated();
            return this.stream().anyMatch(Functions.asPredicate(failablePredicate));
        }
    }
}

