/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.Streams;

public class Functions {
    public static Runnable asRunnable(FailableRunnable<?> failableRunnable) {
        return () -> Functions.run(failableRunnable);
    }

    public static <I> Consumer<I> asConsumer(FailableConsumer<I, ?> failableConsumer) {
        return object -> Functions.accept(failableConsumer, object);
    }

    public static <O> Callable<O> asCallable(FailableCallable<O, ?> failableCallable) {
        return () -> Functions.call(failableCallable);
    }

    public static <I1, I2> BiConsumer<I1, I2> asBiConsumer(FailableBiConsumer<I1, I2, ?> failableBiConsumer) {
        return (object, object2) -> Functions.accept(failableBiConsumer, object, object2);
    }

    public static <I, O> Function<I, O> asFunction(FailableFunction<I, O, ?> failableFunction) {
        return object -> Functions.apply(failableFunction, object);
    }

    public static <I1, I2, O> BiFunction<I1, I2, O> asBiFunction(FailableBiFunction<I1, I2, O, ?> failableBiFunction) {
        return (object, object2) -> Functions.apply(failableBiFunction, object, object2);
    }

    public static <I> Predicate<I> asPredicate(FailablePredicate<I, ?> failablePredicate) {
        return object -> Functions.test(failablePredicate, object);
    }

    public static <I1, I2> BiPredicate<I1, I2> asBiPredicate(FailableBiPredicate<I1, I2, ?> failableBiPredicate) {
        return (object, object2) -> Functions.test(failableBiPredicate, object, object2);
    }

    public static <O> Supplier<O> asSupplier(FailableSupplier<O, ?> failableSupplier) {
        return () -> Functions.get(failableSupplier);
    }

    public static <T extends Throwable> void run(FailableRunnable<T> failableRunnable) {
        try {
            failableRunnable.run();
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> O call(FailableCallable<O, T> failableCallable) {
        try {
            return failableCallable.call();
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> void accept(FailableConsumer<O, T> failableConsumer, O o) {
        try {
            failableConsumer.accept(o);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O1, O2, T extends Throwable> void accept(FailableBiConsumer<O1, O2, T> failableBiConsumer, O1 O1, O2 O2) {
        try {
            failableBiConsumer.accept(O1, O2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <I, O, T extends Throwable> O apply(FailableFunction<I, O, T> failableFunction, I i) {
        try {
            return failableFunction.apply(i);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <I1, I2, O, T extends Throwable> O apply(FailableBiFunction<I1, I2, O, T> failableBiFunction, I1 I1, I2 I2) {
        try {
            return failableBiFunction.apply(I1, I2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> boolean test(FailablePredicate<O, T> failablePredicate, O o) {
        try {
            return failablePredicate.test(o);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O1, O2, T extends Throwable> boolean test(FailableBiPredicate<O1, O2, T> failableBiPredicate, O1 O1, O2 O2) {
        try {
            return failableBiPredicate.test(O1, O2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> O get(FailableSupplier<O, T> failableSupplier) {
        try {
            return failableSupplier.get();
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O> Streams.FailableStream<O> stream(Stream<O> stream) {
        return new Streams.FailableStream<O>(stream);
    }

    public static <O> Streams.FailableStream<O> stream(Collection<O> collection) {
        return new Streams.FailableStream<O>(collection.stream());
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> failableRunnable, FailableConsumer<Throwable, ? extends Throwable> failableConsumer, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        void var4_8;
        FailableConsumer<Throwable, Object> failableConsumer2 = failableConsumer == null ? throwable -> Functions.rethrow(throwable) : failableConsumer;
        if (failableRunnableArray != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable2 : failableRunnableArray) {
                Objects.requireNonNull(failableRunnable2, "runnable");
            }
        }
        Object var4_5 = null;
        try {
            failableRunnable.run();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
        }
        if (failableRunnableArray != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable3 : failableRunnableArray) {
                try {
                    failableRunnable3.run();
                }
                catch (Throwable throwable4) {
                    if (var4_8 != null) continue;
                    Throwable throwable5 = throwable4;
                }
            }
        }
        if (var4_8 != null) {
            try {
                failableConsumer2.accept((Throwable)var4_8);
            }
            catch (Throwable throwable6) {
                throw Functions.rethrow(throwable6);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> failableRunnable, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        Functions.tryWithResources(failableRunnable, null, failableRunnableArray);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        Objects.requireNonNull(throwable, "pThrowable");
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        throw new UndeclaredThrowableException(throwable);
    }

    @FunctionalInterface
    public static interface FailableSupplier<O, T extends Throwable> {
        public O get() throws T;
    }

    @FunctionalInterface
    public static interface FailableBiPredicate<O1, O2, T extends Throwable> {
        public boolean test(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailablePredicate<O, T extends Throwable> {
        public boolean test(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiFunction<I1, I2, O, T extends Throwable> {
        public O apply(I1 var1, I2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableFunction<I, O, T extends Throwable> {
        public O apply(I var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiConsumer<O1, O2, T extends Throwable> {
        public void accept(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableConsumer<O, T extends Throwable> {
        public void accept(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableCallable<O, T extends Throwable> {
        public O call() throws T;
    }

    @FunctionalInterface
    public static interface FailableRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

