/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher;

import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Locale;

public interface HashFunctionIdentity {
    public static final Comparator<HashFunctionIdentity> COMMON_COMPARATOR = new Comparator<HashFunctionIdentity>(){

        @Override
        public int compare(HashFunctionIdentity identity1, HashFunctionIdentity identity2) {
            int result = identity1.getName().compareToIgnoreCase(identity2.getName());
            if (result == 0) {
                result = identity1.getSignedness().compareTo(identity2.getSignedness());
            }
            if (result == 0) {
                result = identity1.getProcessType().compareTo(identity2.getProcessType());
            }
            return result;
        }
    };
    public static final Comparator<HashFunctionIdentity> DEEP_COMPARATOR = new Comparator<HashFunctionIdentity>(){

        @Override
        public int compare(HashFunctionIdentity identity1, HashFunctionIdentity identity2) {
            int result = COMMON_COMPARATOR.compare(identity1, identity2);
            if (result == 0) {
                result = identity1.getProvider().compareToIgnoreCase(identity2.getProvider());
            }
            return result;
        }
    };

    public static String asCommonString(HashFunctionIdentity identity) {
        return String.format("%s-%s-%s", new Object[]{identity.getName(), identity.getSignedness(), identity.getProcessType()});
    }

    public static byte[] prepareSignatureBuffer(HashFunctionIdentity identity) {
        return String.format("%s-%s-%s", new Object[]{identity.getName().toUpperCase(Locale.ROOT), identity.getSignedness(), identity.getProcessType()}).getBytes(StandardCharsets.UTF_8);
    }

    public String getName();

    public String getProvider();

    public Signedness getSignedness();

    public ProcessType getProcessType();

    public long getSignature();

    public static enum ProcessType {
        CYCLIC,
        ITERATIVE;

    }

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }
}

