/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.TreeSet;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;
import org.apache.commons.collections4.bloomfilter.hasher.StaticHasher;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.IteratorChain;

public class HasherBloomFilter
extends AbstractBloomFilter {
    private StaticHasher hasher;

    public HasherBloomFilter(Hasher hasher, Shape shape) {
        super(shape);
        this.verifyHasher(hasher);
        if (hasher instanceof StaticHasher) {
            this.hasher = (StaticHasher)hasher;
            this.verifyShape(this.hasher.getShape());
        } else {
            this.hasher = new StaticHasher(hasher, shape);
        }
    }

    public HasherBloomFilter(Shape shape) {
        super(shape);
        this.hasher = new StaticHasher(EmptyIterator.emptyIterator(), shape);
    }

    @Override
    public long[] getBits() {
        int limit;
        if (this.hasher.size() == 0) {
            return new long[0];
        }
        int n = (int)Math.ceil((double)this.hasher.getShape().getNumberOfBits() * 1.0 / 64.0);
        long[] result = new long[n];
        PrimitiveIterator.OfInt iter = this.hasher.getBits(this.hasher.getShape());
        iter.forEachRemaining(idx -> {
            long buff = result[idx / 64];
            long pwr = Math.floorMod(idx, 64);
            long buffOffset = 1L << (int)pwr;
            result[idx / 64] = buff |= buffOffset;
        });
        for (limit = result.length; limit > 0 && result[limit - 1] == 0L; --limit) {
        }
        if (limit == 0) {
            return new long[0];
        }
        if (limit < result.length) {
            return Arrays.copyOf(result, limit);
        }
        return result;
    }

    @Override
    public StaticHasher getHasher() {
        return this.hasher;
    }

    @Override
    public void merge(BloomFilter other) {
        this.merge(other.getHasher());
    }

    @Override
    public void merge(Hasher hasher) {
        this.verifyHasher(hasher);
        IteratorChain<Integer> iter = new IteratorChain<Integer>(this.hasher.getBits(this.getShape()), hasher.getBits(this.getShape()));
        this.hasher = new StaticHasher(iter, this.getShape());
    }

    @Override
    public int cardinality() {
        return this.hasher.size();
    }

    @Override
    public boolean contains(Hasher hasher) {
        this.verifyHasher(hasher);
        TreeSet set = new TreeSet();
        hasher.getBits(this.getShape()).forEachRemaining(idx -> set.add(idx));
        PrimitiveIterator.OfInt iter = this.hasher.getBits(this.getShape());
        while (iter.hasNext()) {
            int idx2 = iter.nextInt();
            set.remove(idx2);
            if (!set.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

