/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Color;
import java.awt.Stroke;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;

public class FDSettings {
    public NamedColorProperty COLOR_FIXED = new NamedColorProperty("fastdraw.color.delete", Color.red);
    public NamedColorProperty COLOR_NORMAL = new NamedColorProperty("fastdraw.color.edit", Color.orange);
    public NamedColorProperty COLOR_DELETE = new NamedColorProperty("fastdraw.color.fixed", Color.green);
    public NamedColorProperty COLOR_SELECTEDFRAGMENT = new NamedColorProperty("fastdraw.color.normal", Color.red);
    public NamedColorProperty COLOR_EDITEDFRAGMENT = new NamedColorProperty("fastdraw.color.select", Color.blue);
    public NamedColorProperty COLOR_SIMPLIFIED = new NamedColorProperty("fastdraw.color.simplified", Color.orange);
    public double maxDist;
    public double epsilonMult;
    public double minPixelsBetweenPoints;
    public double startingEps;
    public double maxPointsPerKm;
    public int pkmBlockSize;
    public boolean drawLastSegment;
    public boolean snapNodes;
    public boolean fixedClick;
    public boolean fixedSpacebar;
    public boolean allowEditExistingWays;
    public boolean drawClosed;
    public int simplifyMode;
    public String autoTags;
    public Stroke normalStroke;
    public Stroke simplifiedStroke;
    public Stroke deleteStroke;
    public int dotSize;
    public int bigDotSize;

    public void loadPrefs() {
        this.normalStroke = GuiHelper.getCustomizedStroke((String)Config.getPref().get("fastdraw.stroke.normal", "2"));
        this.deleteStroke = GuiHelper.getCustomizedStroke((String)Config.getPref().get("fastdraw.stroke.delete", "3"));
        this.simplifiedStroke = GuiHelper.getCustomizedStroke((String)Config.getPref().get("fastdraw.stroke.simplified", "2"));
        this.bigDotSize = Config.getPref().getInt("fastdraw.point.bigsize", 7);
        this.dotSize = Config.getPref().getInt("fastdraw.point.normalsize", 5);
        this.maxDist = Config.getPref().getDouble("fastdraw.maxdist", 5.0);
        this.epsilonMult = Config.getPref().getDouble("fastdraw.epsilonmult", 1.1);
        this.minPixelsBetweenPoints = Config.getPref().getDouble("fastdraw.mindelta", 20.0);
        this.startingEps = Config.getPref().getDouble("fastdraw.startingEps", 5.0);
        this.maxPointsPerKm = Config.getPref().getDouble("fastdraw.maxpkm", 150.0);
        this.pkmBlockSize = Config.getPref().getInt("fastdraw.pkmblocksize", 10);
        this.drawLastSegment = Config.getPref().getBoolean("fastdraw.drawlastsegment", true);
        this.snapNodes = Config.getPref().getBoolean("fastdraw.snapnodes", true);
        this.fixedClick = Config.getPref().getBoolean("fastdraw.fixedclick", false);
        this.fixedSpacebar = Config.getPref().getBoolean("fastdraw.fixedspacebar", false);
        this.drawClosed = Config.getPref().getBoolean("fastdraw.drawclosed", false);
        this.simplifyMode = Config.getPref().getInt("fastdraw.simplifymode", 0) % 3;
        this.allowEditExistingWays = Config.getPref().getBoolean("fastdraw.alloweditexisting", false);
        this.autoTags = Config.getPref().get("fastdraw.autotags");
    }

    public void savePrefs() {
        Config.getPref().putDouble("fastdraw.maxdist", this.maxDist);
        Config.getPref().putDouble("fastdraw.epsilonmult", this.epsilonMult);
        Config.getPref().putDouble("fastdraw.mindelta", this.minPixelsBetweenPoints);
        Config.getPref().putDouble("fastdraw.startingEps", this.startingEps);
        Config.getPref().putDouble("fastdraw.maxpkm", this.maxPointsPerKm);
        Config.getPref().putInt("fastdraw.pkmblocksize", this.pkmBlockSize);
        Config.getPref().putBoolean("fastdraw.drawlastsegment", this.drawLastSegment);
        Config.getPref().putBoolean("fastdraw.snapnodes", this.snapNodes);
        Config.getPref().putBoolean("fastdraw.fixedclick", this.fixedClick);
        Config.getPref().putBoolean("fastdraw.fixedspacebar", this.fixedSpacebar);
        Config.getPref().putBoolean("fastdraw.drawclosed", this.drawClosed);
        Config.getPref().putInt("fastdraw.simplifymode", this.simplifyMode);
        Config.getPref().put("fastdraw.autotags", this.autoTags);
        Config.getPref().putBoolean("fastdraw.alloweditexisting", this.allowEditExistingWays);
    }
}

