/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.C;
import com.sun.glass.ui.monocle.LinuxSystem;
import java.io.IOException;
import java.nio.ByteBuffer;

class LinuxFrameBuffer {
    private long fd;
    private LinuxSystem system = LinuxSystem.getLinuxSystem();
    private LinuxSystem.FbVarScreenInfo screenInfo;
    private int width;
    private int height;
    private int bitDepth;
    private int byteDepth;
    private int offsetX;
    private int offsetY;
    private int offsetY1;
    private int offsetY2;
    private int offsetX1;
    private int offsetX2;
    private int state;
    private int FBIO_WAITFORVSYNC = this.system.IOW(70, 32, 4);

    LinuxFrameBuffer(String devNode) throws IOException {
        this.fd = this.system.open(devNode, 2);
        if (this.fd == -1L) {
            throw new IOException(this.system.getErrorMessage());
        }
        this.screenInfo = new LinuxSystem.FbVarScreenInfo();
        if (this.system.ioctl(this.fd, 17920, this.screenInfo.p) != 0) {
            this.system.close(this.fd);
            throw new IOException(this.system.getErrorMessage());
        }
        this.bitDepth = this.screenInfo.getBitsPerPixel(this.screenInfo.p);
        this.byteDepth = this.bitDepth >>> 3;
        this.width = this.screenInfo.getXRes(this.screenInfo.p);
        this.height = this.screenInfo.getYRes(this.screenInfo.p);
        int virtualWidth = this.screenInfo.getXResVirtual(this.screenInfo.p);
        int virtualHeight = this.screenInfo.getYResVirtual(this.screenInfo.p);
        this.offsetX = this.screenInfo.getOffsetX(this.screenInfo.p);
        this.offsetY = this.screenInfo.getOffsetY(this.screenInfo.p);
        if (virtualHeight >= this.height * 2) {
            if (this.offsetY >= this.height) {
                this.offsetY1 = this.offsetY;
                this.offsetY2 = 0;
            } else if (virtualHeight - this.offsetY >= this.height * 2) {
                this.offsetY1 = this.offsetY;
                this.offsetY2 = this.offsetY + this.height;
            } else {
                this.offsetY1 = 0;
                this.offsetY2 = this.width * this.byteDepth;
            }
            this.offsetX1 = this.offsetX2 = this.offsetX;
            this.state = 1;
        } else if (virtualWidth >= this.width * 2) {
            if (this.offsetX >= this.width) {
                this.offsetX1 = this.offsetX;
                this.offsetX2 = 0;
            } else if (virtualWidth - this.offsetX >= this.width * 2) {
                this.offsetX1 = this.offsetX;
                this.offsetX2 = this.offsetX + this.height;
            } else {
                this.offsetX1 = 0;
                this.offsetX2 = this.width * this.byteDepth;
            }
            this.offsetY1 = this.offsetY2 = this.offsetY;
            this.state = 1;
        }
    }

    boolean canDoubleBuffer() {
        return this.state != 0;
    }

    int getNativeOffset() {
        int nativeOffsetX = this.screenInfo.getOffsetX(this.screenInfo.p);
        int nativeOffsetY = this.screenInfo.getOffsetY(this.screenInfo.p);
        if (this.system.ioctl(this.fd, 17920, this.screenInfo.p) == 0) {
            nativeOffsetX = this.screenInfo.getOffsetX(this.screenInfo.p);
            nativeOffsetY = this.screenInfo.getOffsetY(this.screenInfo.p);
        }
        return nativeOffsetY * this.width * this.byteDepth;
    }

    int getNextAddress() {
        switch (this.state) {
            case 1: {
                return (this.offsetX2 + this.offsetY2 * this.width) * this.byteDepth;
            }
            case 2: {
                return (this.offsetX1 + this.offsetY1 * this.width) * this.byteDepth;
            }
        }
        return (this.offsetX + this.offsetY * this.width) * this.byteDepth;
    }

    void next() throws IOException {
        if (this.state != 0) {
            int newOffsetY;
            int newOffsetX;
            if (this.state == 1) {
                newOffsetX = this.offsetX2;
                newOffsetY = this.offsetY2;
            } else {
                newOffsetX = this.offsetX1;
                newOffsetY = this.offsetY1;
            }
            this.screenInfo.setActivate(this.screenInfo.p, 16);
            this.screenInfo.setOffset(this.screenInfo.p, newOffsetX, newOffsetY);
            if (this.system.ioctl(this.fd, 17926, this.screenInfo.p) != 0) {
                this.state = 0;
                throw new IOException(this.system.getErrorMessage());
            }
            this.offsetX = newOffsetX;
            this.offsetY = newOffsetY;
            this.state = 3 - this.state;
        }
    }

    void vSync() {
        this.system.ioctl(this.fd, this.FBIO_WAITFORVSYNC, 0L);
    }

    ByteBuffer getMappedBuffer() {
        int mappedFBSize = this.screenInfo.getXResVirtual(this.screenInfo.p) * this.screenInfo.getYResVirtual(this.screenInfo.p) * this.byteDepth;
        long addr = this.system.mmap(0L, mappedFBSize, 2L, 1L, this.fd, 0L);
        if (addr != 0xFFFFFFFFL) {
            return C.getC().NewDirectByteBuffer(addr, mappedFBSize);
        }
        return null;
    }

    void releaseMappedBuffer(ByteBuffer b) {
        this.system.munmap(C.getC().GetDirectBufferAddress(b), b.capacity());
    }

    void close() {
        this.system.close(this.fd);
    }

    boolean isDoubleBuffer() {
        return this.state > 0;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    int getDepth() {
        return this.bitDepth;
    }
}

