/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.core.datasets.SimpleDataSetHandler;
import org.openstreetmap.josm.tools.Logging;

public abstract class NamesFrUtils {
    private static Map<String, String> dictionary = NamesFrUtils.initDictionary();

    public static final String checkDictionary(String value) {
        String result = "";
        for (String word : value.split(" ")) {
            if (!result.isEmpty()) {
                result = result + " ";
            }
            result = result + (dictionary.containsKey(word) ? dictionary.get(word) : word);
        }
        return result;
    }

    private static Map<String, String> initDictionary() {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SimpleDataSetHandler.class.getResourceAsStream("/resources/org/openstreetmap/josm/plugins/opendata/core/resources/dictionary.fr.csv"), "UTF-8"));){
            String line = reader.readLine();
            Logging.trace((String)line);
            while ((line = reader.readLine()) != null) {
                String[] tab = line.split(";");
                result.put(tab[0].replace("\"", ""), tab[1].replace("\"", ""));
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        return result;
    }

    public static final String getStreetLabel(String label) {
        if (label == null) {
            return label;
        }
        if (label.startsWith("All")) {
            return "All\u00e9e";
        }
        if (label.equals("Autoroute")) {
            return label;
        }
        if (label.startsWith("Anc")) {
            return "Ancien";
        }
        if (label.startsWith("Av")) {
            return "Avenue";
        }
        if (label.startsWith("Barr")) {
            return "Barri\u00e8re";
        }
        if (label.equals("Bd") || label.equals("Boulevard")) {
            return "Boulevard";
        }
        if (label.startsWith("Bret")) {
            return "Bretelle";
        }
        if (label.equals("Bre")) {
            return "Br\u00e9";
        }
        if (label.equals("Caminot")) {
            return label;
        }
        if (label.equals("Carrefour")) {
            return label;
        }
        if (label.equals("Carr\u00e9")) {
            return label;
        }
        if (label.startsWith("Chemine")) {
            return "Cheminement";
        }
        if (label.startsWith("Che")) {
            return "Chemin";
        }
        if (label.startsWith("Cit")) {
            return "Cit\u00e9";
        }
        if (label.equals("Clos")) {
            return label;
        }
        if (label.equals("Cote") || label.equals("C\u00f4te")) {
            return "C\u00f4te";
        }
        if (label.equals("Cours")) {
            return label;
        }
        if (label.startsWith("Dep") || label.startsWith("D\u00e9p")) {
            return "D\u00e9partementale";
        }
        if (label.startsWith("Dom")) {
            return "Domaine";
        }
        if (label.equals("Dsc") || label.startsWith("Desc")) {
            return "Descente";
        }
        if (label.equals("Esp") || label.startsWith("Espl")) {
            return "Esplanade";
        }
        if (label.startsWith("Espa")) {
            return "Espace";
        }
        if (label.equals("Giratoire")) {
            return label;
        }
        if (label.equals("Grande-rue")) {
            return label;
        }
        if (label.equals("Hameau")) {
            return label;
        }
        if (label.startsWith("Imp") || label.equals("Ipasse")) {
            return "Impasse";
        }
        if (label.startsWith("Itin")) {
            return "Itin\u00e9raire";
        }
        if (label.equals("Jardin")) {
            return label;
        }
        if (label.startsWith("L'") || label.equals("La") || label.equals("Le") || label.equals("Les") || label.equals("Saint")) {
            return label;
        }
        if (label.startsWith("Lot")) {
            return "Lotissement";
        }
        if (label.equals("Mail")) {
            return label;
        }
        if (label.equals("Mas")) {
            return label;
        }
        if (label.startsWith("Nat")) {
            return "Nationale";
        }
        if (label.equals("Parc")) {
            return label;
        }
        if (label.equals("Passerelle")) {
            return label;
        }
        if (label.startsWith("Pas")) {
            return "Passage";
        }
        if (label.equals("Pch") || label.startsWith("Petit-chem")) {
            return "Petit-chemin";
        }
        if (label.equals("Petit") || label.equals("Petite")) {
            return label;
        }
        if (label.equals("Petite-all\u00e9e")) {
            return label;
        }
        if (label.equals("Petite-rue")) {
            return label;
        }
        if (label.equals("Plan")) {
            return label;
        }
        if (label.startsWith("Pl")) {
            return "Place";
        }
        if (label.equals("Pont")) {
            return label;
        }
        if (label.equals("Port")) {
            return label;
        }
        if (label.equals("Porte")) {
            return label;
        }
        if (label.startsWith("Prom")) {
            return "Promenade";
        }
        if (label.equals("Prv") || label.startsWith("Parv")) {
            return "Parvis";
        }
        if (label.startsWith("Qu")) {
            return "Quai";
        }
        if (label.equals("Rampe")) {
            return label;
        }
        if (label.startsWith("Res") || label.startsWith("R\u00e9s")) {
            return "R\u00e9sidence";
        }
        if (label.equals("Rocade")) {
            return label;
        }
        if (label.equals("Rpt") || label.startsWith("Ron")) {
            return "Rond-Point";
        }
        if (label.equals("Rte") || label.equals("Route")) {
            return "Route";
        }
        if (label.equals("Rue") || label.equals("Rued")) {
            return "Rue";
        }
        if (label.equals("Sentier")) {
            return label;
        }
        if (label.startsWith("Sq")) {
            return "Square";
        }
        if (label.equals("Th\u00e9\u00e2tre")) {
            return "Th\u00e9\u00e2tre";
        }
        if (label.startsWith("Tra")) {
            return "Traverse";
        }
        if (label.equals("Vieux")) {
            return label;
        }
        if (label.equals("Voie")) {
            return label;
        }
        if (label.equals("Zone")) {
            return label;
        }
        Logging.warn((String)("unknown street label: " + label));
        return label;
    }

    public static final String checkStreetName(OsmPrimitive p, String key) {
        String value = null;
        if (p != null && (value = p.get(key)) != null) {
            String[] words;
            if ((value = WordUtils.capitalizeFully((String)value)).equals("Boulingrin")) {
                value = "Sq Boulingrin";
            } else if (value.matches("A[0-9]+")) {
                value = "Autoroute " + value;
            } else if (value.equals("All A61")) {
                value = "Autoroute A61";
            } else if (value.startsWith("Che Vieux Che")) {
                value = value.replaceFirst("Che ", "");
            } else if (value.startsWith("Petite Allee ")) {
                value = value.replaceFirst("Petite Allee ", "Petite-all\u00e9e ");
            } else if (value.startsWith("Ld De ")) {
                value = value.replaceFirst("Ld De ", "");
            }
            while (value.startsWith("Ld ")) {
                value = value.replaceFirst("Ld ", "");
            }
            if (value.startsWith("L ")) {
                value = value.replaceFirst("L ", "L'");
            }
            if ((words = value.split(" ")).length > 0) {
                value = "";
                List<String> list = Arrays.asList(words);
                words[0] = NamesFrUtils.getStreetLabel(words[0]);
                if (words[0].equals("Ancien") && words.length > 1 && words[1].equals("Che")) {
                    words[1] = "Chemin";
                }
                for (int i = 0; i < words.length; ++i) {
                    if (i > 0) {
                        value = value + " ";
                        if (words[i].equals("A") && list.contains("Bernard")) {
                            words[i] = "Arnaud";
                        } else if (words[i].equals("A") && list.contains("Passerieu")) {
                            words[i] = "Ariste";
                        } else if (words[i].equals("A") && list.contains("Bougainville")) {
                            words[i] = "Antoine";
                        } else if (words[i].equals("Ch") && list.contains("Leconte")) {
                            words[i] = "Charles";
                        } else if (words[i].equals("Frs") && list.contains("Dugua")) {
                            words[i] = "Fran\u00e7ois";
                        } else if (words[i].equals("G") && list.contains("Latecoere")) {
                            words[i] = "Georges";
                        } else if (words[i].equals("H") && list.contains("Lautrec")) {
                            words[i] = "Henri";
                        } else if (words[i].equals("J") && list.contains("Dieulafoy")) {
                            words[i] = "Jane";
                        } else if (words[i].equals("J") && (list.contains("Champollion") || list.contains("Stanislas"))) {
                            words[i] = "Jean";
                        } else if (words[i].equals("L") && list.contains("Zamenhof")) {
                            words[i] = "Ludwik";
                        } else if (words[i].equals("L") && list.contains("Sacha")) {
                            words[i] = "Lucien";
                            if (!list.contains("Et")) {
                                int n = i;
                                words[n] = words[n] + " et";
                            }
                        } else if (words[i].equals("L") && (list.contains("Vauquelin") || list.contains("Bougainville"))) {
                            words[i] = "Louis";
                        } else if (words[i].equals("M") && list.contains("Dieulafoy")) {
                            words[i] = "Marcel";
                        } else if (words[i].equals("M") && list.contains("Arifat")) {
                            words[i] = "Marie";
                        } else if (words[i].equals("N") && list.contains("Djamena")) {
                            words[i] = "N'";
                        } else if (words[i].equals("Oo")) {
                            words[i] = "O\u00f4";
                        } else if (words[i].equals("Ph") && list.contains("Ravary")) {
                            words[i] = "Philippe";
                        } else if (words[i].equals("R") && list.contains("Folliot")) {
                            words[i] = "Rapha\u00ebl";
                        } else if (words[i].equals("W") && list.contains("Booth")) {
                            words[i] = "William";
                        } else if (words[i].equals("A")) {
                            words[i] = "\u00e0";
                        } else if (words[i].equals("D") || words[i].equals("L")) {
                            words[i] = words[i].toLowerCase() + "'";
                        } else if (words[i].equals("La") || words[i].equals("Le")) {
                            words[i] = words[i].toLowerCase();
                        }
                    }
                    value = value + words[i];
                }
            }
            value = value.replace("' ", "'");
            value = NamesFrUtils.checkDictionary(value);
            p.put(key, value);
        }
        return value;
    }
}

