/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;

public class PropertySetFactory {
    public static PropertySet create(InputStream inputStream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet propertySet = new PropertySet(inputStream);
        try {
            if (propertySet.isSummaryInformation()) {
                return new SummaryInformation(propertySet);
            }
            if (propertySet.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(propertySet);
            }
            return propertySet;
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new UnexpectedException(unexpectedPropertySetTypeException.toString());
        }
    }
}

