/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class Http2Client
extends HttpClient {
    private HttpClient.Builder clientBuilder;
    private HttpRequest.Builder requestBuilder;
    private HttpResponse<InputStream> response;

    Http2Client(URL url, String requestMethod) {
        super(url, requestMethod);
    }

    protected void setupConnection(ProgressMonitor progressMonitor) throws IOException {
        this.clientBuilder = java.net.http.HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER);
        int timeout = this.getConnectTimeout();
        if (timeout > 0) {
            this.clientBuilder.connectTimeout(Duration.ofMillis(timeout));
        }
        try {
            this.requestBuilder = HttpRequest.newBuilder().uri(this.getURL().toURI()).method(this.getRequestMethod(), this.hasRequestBody() ? HttpRequest.BodyPublishers.ofByteArray(this.getRequestBody()) : HttpRequest.BodyPublishers.noBody()).header("User-Agent", Version.getInstance().getFullAgentString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        timeout = this.getReadTimeout();
        if (timeout > 0) {
            this.requestBuilder.timeout(Duration.ofMillis(timeout));
        }
        if (this.getIfModifiedSince() > 0L) {
            this.requestBuilder.header("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getIfModifiedSince()), ZoneId.systemDefault())));
        }
        if (!this.isUseCache()) {
            this.requestBuilder.header("Cache-Control", "no-cache");
        }
        for (Map.Entry header : this.getHeaders().entrySet()) {
            if (header.getValue() == null) continue;
            try {
                this.requestBuilder.header((String)header.getKey(), (String)header.getValue());
            }
            catch (IllegalArgumentException e) {
                Logging.warn((String)e.getMessage());
            }
        }
        this.notifyConnect(progressMonitor);
        if (this.requiresBody()) {
            this.logRequestBody();
        }
    }

    protected HttpClient.ConnectionResponse performConnection() throws IOException {
        try {
            this.response = this.clientBuilder.build().send(this.requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            return new HttpClient.ConnectionResponse(){

                public String getResponseVersion() {
                    return Http2Client.this.response.version().name();
                }

                public int getResponseCode() throws IOException {
                    return Http2Client.this.response.statusCode();
                }

                public long getContentLengthLong() {
                    return Http2Client.this.response.headers().firstValueAsLong("Content-Length").orElse(-1L);
                }

                public Map<String, List<String>> getHeaderFields() {
                    return Http2Client.this.response.headers().map();
                }

                public String getHeaderField(String name) {
                    String list = String.join((CharSequence)",", Http2Client.this.response.headers().allValues(name));
                    return list.isEmpty() ? null : list;
                }
            };
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected HttpClient.Response buildResponse(ProgressMonitor progressMonitor) throws IOException {
        return new Http2Response(this.response, progressMonitor);
    }

    protected void performDisconnection() throws IOException {
    }

    public void disconnect() {
    }

    public static final class Http2Response
    extends HttpClient.Response {
        private final HttpResponse<InputStream> response;

        public Http2Response(HttpResponse<InputStream> response, ProgressMonitor progressMonitor) throws IOException {
            super(progressMonitor, response.statusCode(), null);
            this.response = Objects.requireNonNull(response);
            this.debugRedirect();
        }

        public URL getURL() {
            try {
                return this.response.uri().toURL();
            }
            catch (MalformedURLException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
        }

        public String getRequestMethod() {
            return this.response.request().method();
        }

        protected InputStream getInputStream() throws IOException {
            return this.response.body();
        }

        public String getContentEncoding() {
            return this.response.headers().firstValue("Content-Encoding").orElse(null);
        }

        public String getContentType() {
            return this.response.headers().firstValue("Content-Type").orElse(null);
        }

        public long getExpiration() {
            return this.response.headers().firstValue("Expires").map(DateTimeFormatter.RFC_1123_DATE_TIME::parse).map(t -> 1000L * t.getLong(ChronoField.INSTANT_SECONDS)).orElse(0L);
        }

        public long getLastModified() {
            return this.response.headers().firstValue("Last-Modified").map(DateTimeFormatter.RFC_1123_DATE_TIME::parse).map(t -> 1000L * t.getLong(ChronoField.INSTANT_SECONDS)).orElse(0L);
        }

        public long getContentLength() {
            return this.response.headers().firstValueAsLong("Content-Length").orElse(-1L);
        }

        public String getHeaderField(String name) {
            String list = String.join((CharSequence)",", this.response.headers().allValues(name));
            return list.isEmpty() ? null : list;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.response.headers().map();
        }

        public void disconnect() {
            Utils.close((Closeable)this.response.body());
        }
    }
}

