/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.MovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.AutoCalibrator;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.helper.ObservableArrayList;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.CalibrationErrorView;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.CalibrationWindow;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.ReferenceOptionView;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.ResultCheckView;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.SelectLayerView;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.Logging;

public class AutoCalibrateHandler {
    private PicLayerAbstract currentPicLayer = null;
    private CalibrationWindow mainWindow;
    private CalibrationErrorView errorView;
    private ReferenceOptionView refOptionView;
    private File referenceFile = null;
    private Layer referenceLayer = null;
    private AutoCalibrator calibrator;
    private ObservableArrayList<Point2D> originPointList = new ObservableArrayList(3);
    private ObservableArrayList<Point2D> referencePointList = new ObservableArrayList(3);
    private double distance1To2 = 0.0;
    private double distance2To3 = 0.0;

    public AutoCalibrateHandler() {
        this.mainWindow = new CalibrationWindow();
        this.addListenerToMainView();
        this.calibrator = new AutoCalibrator();
    }

    private void callCalibrator() {
        if (this.currentPicLayer != null && this.originPointList.size() > 0 && this.referencePointList.size() > 0 && this.distance1To2 != 0.0 && this.distance2To3 != 0.0) {
            this.calibrator.setCurrentLayer(this.currentPicLayer);
            this.calibrator.setStartPositions(this.originPointList);
            this.calibrator.setEndPositions(this.referencePointList);
            this.calibrator.setDistance1To2(this.distance1To2);
            this.calibrator.setDistance2To3(this.distance2To3);
            this.calibrator.calibrate();
        } else {
            this.calibrator.showErrorView(CalibrationErrorView.CALIBRATION_ERROR);
        }
    }

    private void addListenerToMainView() {
        if (this.mainWindow != null) {
            this.mainWindow.addHelpButtonListener(new HelpButtonListener());
            this.mainWindow.addEdgePointButtonListener(new EdgePointsButtonListener());
            this.mainWindow.addDistance1FieldListener(new TextField1Listener());
            this.mainWindow.addDistance2FieldListener(new TextField2Listener());
            this.mainWindow.addOpenFileButtonListener(new OpenFileButtonListener());
            this.mainWindow.addSelectLayerButtonListener(new SelectLayerButtonListener());
            this.mainWindow.addReferencePointButtonListener(new RefPointsButtonListener());
            this.mainWindow.addCancelButtonListener(new CancelButtonListener());
            this.mainWindow.addRunButtonListener(new RunButtonListener());
            this.mainWindow.addFrameWindowListener(this.getToolWindowListener());
        }
    }

    private WindowAdapter getToolWindowListener() {
        WindowAdapter adapter = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent wEvt) {
                ((JFrame)wEvt.getSource()).toFront();
            }

            @Override
            public void windowClosing(WindowEvent wEvt) {
                AutoCalibrateHandler.this.reset();
                AutoCalibrateHandler.this.removeListChangedListener();
            }
        };
        return adapter;
    }

    public CalibrationWindow getMainWindow() {
        return this.mainWindow;
    }

    public CalibrationErrorView getErrorView() {
        this.errorView = new CalibrationErrorView();
        return this.errorView;
    }

    public void prepare(PicLayerAbstract layer) {
        this.currentPicLayer = layer;
        this.addListChangedListenerToPointLists();
        ObservableArrayList<Point2D> list = layer.getTransformer().getLatLonOriginPoints();
        if (list != null && list.size() == 3) {
            this.originPointList = list;
            this.mainWindow.setOriginPoints(this.originPointList);
        } else {
            this.resetLists();
        }
    }

    private void reset() {
        this.originPointList = new ObservableArrayList(3);
        this.referencePointList = new ObservableArrayList(3);
        this.distance1To2 = 0.0;
        this.distance2To3 = 0.0;
        this.referenceFile = null;
        this.referenceLayer = null;
        this.resetLists();
        this.currentPicLayer.clearDrawReferencePoints();
        this.currentPicLayer.invalidate();
        this.mainWindow.setVisible(false);
        this.mainWindow = new CalibrationWindow();
        this.addListenerToMainView();
    }

    private void resetLists() {
        this.currentPicLayer.getTransformer().clearOriginPoints();
        this.currentPicLayer.getTransformer().clearLatLonOriginPoints();
    }

    private void addListChangedListenerToPointLists() {
        OriginSizePropertyListener originListener = new OriginSizePropertyListener();
        this.currentPicLayer.getTransformer().getLatLonOriginPoints().addPropertyChangeListener(originListener);
        RefSizePropertyListener refListener = new RefSizePropertyListener();
        this.referencePointList.addPropertyChangeListener(refListener);
    }

    private void removeListChangedListener() {
        this.currentPicLayer.getTransformer().getLatLonOriginPoints().removeAllListener();
        this.referencePointList.removeAllListener();
    }

    private Point2D translatePointToPicLayerScale(Point2D point) {
        Point2D translatedPoint = null;
        LatLon ll = new LatLon(point.getY(), point.getX());
        MapViewState.MapViewPoint en = MainApplication.getMap().mapView.getState().getPointFor(ll);
        try {
            translatedPoint = this.currentPicLayer.transformPoint(new Point2D.Double(en.getInViewX(), en.getInViewY()));
        }
        catch (NoninvertibleTransformException e) {
            Logging.error((Throwable)e);
        }
        return translatedPoint;
    }

    private boolean validValue(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NullPointerException | NumberFormatException ex) {
            return false;
        }
    }

    private void addFileInNewLayer(File file) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        OpenFileAction.openFiles(files);
    }

    private class RefDefinedPointsMouseListener
    implements MouseListener {
        private RefDefinedPointsMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (AutoCalibrateHandler.this.referenceFile == null && AutoCalibrateHandler.this.referenceLayer == null) {
                MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
                return;
            }
            if (AutoCalibrateHandler.this.referencePointList.size() < 3) {
                LatLon latLonPoint = MainApplication.getMap().mapView.getLatLon(e.getPoint().getX(), e.getPoint().getY());
                double latY = latLonPoint.getY();
                double lonX = latLonPoint.getX();
                Point2D.Double llPoint = new Point2D.Double(lonX, latY);
                Point2D.Double closestPoint = null;
                double shortestDistance = 1000000.0;
                DataSet data = MainApplication.getLayerManager().getEditDataSet();
                for (Node node : data.getNodes()) {
                    double tmpDistance = llPoint.distance(node.lon(), node.lat());
                    if (!(tmpDistance < shortestDistance)) continue;
                    closestPoint = new Point2D.Double(node.lon(), node.lat());
                    shortestDistance = tmpDistance;
                }
                if (closestPoint != null) {
                    AutoCalibrateHandler.this.referencePointList.add(closestPoint);
                    AutoCalibrateHandler.this.currentPicLayer.setDrawReferencePoints(true, AutoCalibrateHandler.this.translatePointToPicLayerScale(closestPoint));
                    AutoCalibrateHandler.this.currentPicLayer.invalidate();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class RefManualPointsMouseListener
    implements MouseListener {
        private RefManualPointsMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (AutoCalibrateHandler.this.referenceFile == null && AutoCalibrateHandler.this.referenceLayer == null) {
                MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
                return;
            }
            if (AutoCalibrateHandler.this.referencePointList.size() < 3) {
                LatLon latLonPoint = MainApplication.getMap().mapView.getLatLon(e.getPoint().getX(), e.getPoint().getY());
                ICoordinateFormat mCoord = CoordinateFormatManager.getDefaultFormat();
                double latY = Double.parseDouble(mCoord.latToString((ILatLon)latLonPoint));
                double lonX = Double.parseDouble(mCoord.lonToString((ILatLon)latLonPoint));
                Point2D.Double llPoint = new Point2D.Double(lonX, latY);
                AutoCalibrateHandler.this.referencePointList.add(llPoint);
                AutoCalibrateHandler.this.currentPicLayer.setDrawReferencePoints(true, AutoCalibrateHandler.this.translatePointToPicLayerScale(llPoint));
                AutoCalibrateHandler.this.currentPicLayer.invalidate();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class RefPointsButtonListener
    implements ActionListener {
        private RefPointsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCalibrateHandler.this.mainWindow.setVisible(false);
            AutoCalibrateHandler.this.refOptionView = new ReferenceOptionView();
            int selectedValue = AutoCalibrateHandler.this.refOptionView.showAndChoose();
            if (selectedValue == 0) {
                MainApplication.getMap().mapView.addMouseListener((MouseListener)new RefDefinedPointsMouseListener());
            } else if (selectedValue == 1) {
                MainApplication.getMap().mapView.addMouseListener((MouseListener)new RefManualPointsMouseListener());
            }
        }
    }

    private class TextField2Listener
    implements FocusListener {
        private TextField2Listener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            AutoCalibrateHandler.this.currentPicLayer.setDrawSecLine(true);
            AutoCalibrateHandler.this.currentPicLayer.invalidate();
            AutoCalibrateHandler.this.mainWindow.setDistance2Field("");
        }

        @Override
        public void focusLost(FocusEvent e) {
            AutoCalibrateHandler.this.currentPicLayer.setDrawSecLine(false);
            AutoCalibrateHandler.this.currentPicLayer.invalidate();
            String value = AutoCalibrateHandler.this.mainWindow.getDistance2FieldText();
            if (AutoCalibrateHandler.this.validValue(value)) {
                AutoCalibrateHandler.this.mainWindow.getDistance2Field().selectAll();
                AutoCalibrateHandler.this.mainWindow.setDistance2Value(value);
                AutoCalibrateHandler.this.mainWindow.refresh();
                AutoCalibrateHandler.this.distance2To3 = Double.parseDouble(value);
            }
        }
    }

    private class TextField1Listener
    implements FocusListener {
        private TextField1Listener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            AutoCalibrateHandler.this.currentPicLayer.setDrawFirstLine(true);
            AutoCalibrateHandler.this.currentPicLayer.invalidate();
            AutoCalibrateHandler.this.mainWindow.setDistance1Field("");
        }

        @Override
        public void focusLost(FocusEvent e) {
            AutoCalibrateHandler.this.currentPicLayer.setDrawFirstLine(false);
            AutoCalibrateHandler.this.currentPicLayer.invalidate();
            String value = AutoCalibrateHandler.this.mainWindow.getDistance1FieldText();
            if (AutoCalibrateHandler.this.validValue(value)) {
                AutoCalibrateHandler.this.mainWindow.getDistance1Field().selectAll();
                AutoCalibrateHandler.this.mainWindow.setDistance1Value(value);
                AutoCalibrateHandler.this.mainWindow.refresh();
                AutoCalibrateHandler.this.distance1To2 = Double.parseDouble(value);
            }
        }
    }

    private class RefSizePropertyListener
    implements PropertyChangeListener {
        private RefSizePropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            int size = (Integer)event.getNewValue();
            AutoCalibrateHandler.this.mainWindow.setReferencePoints(AutoCalibrateHandler.this.referencePointList);
            if (size == 3) {
                AutoCalibrateHandler.this.mainWindow.setVisible(true);
                AutoCalibrateHandler.this.referencePointList.removePropertyChangeListener(this);
            }
        }
    }

    private class OriginSizePropertyListener
    implements PropertyChangeListener {
        private OriginSizePropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            int size = (Integer)event.getNewValue();
            if (AutoCalibrateHandler.this.currentPicLayer.getTransformer().getLatLonOriginPoints() != null) {
                AutoCalibrateHandler.this.originPointList.clear();
                AutoCalibrateHandler.this.originPointList.addAll(AutoCalibrateHandler.this.currentPicLayer.getTransformer().getLatLonOriginPoints());
                AutoCalibrateHandler.this.mainWindow.setOriginPoints(AutoCalibrateHandler.this.originPointList);
            }
            if (size == 3) {
                AutoCalibrateHandler.this.mainWindow.setVisible(true);
                AutoCalibrateHandler.this.currentPicLayer.getTransformer().getLatLonOriginPoints().removePropertyChangeListener(this);
            }
        }
    }

    private class EdgePointsButtonListener
    implements ActionListener {
        private EdgePointsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCalibrateHandler.this.mainWindow.setVisible(false);
            MainApplication.getLayerManager().setActiveLayer((Layer)AutoCalibrateHandler.this.currentPicLayer);
            MovePointAction selectPointMode = new MovePointAction();
            MainApplication.getMap().selectMapMode((MapMode)selectPointMode);
        }
    }

    private class RunButtonListener
    implements ActionListener {
        private RunButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCalibrateHandler.this.callCalibrator();
            AutoCalibrateHandler.this.currentPicLayer.clearDrawReferencePoints();
            AutoCalibrateHandler.this.currentPicLayer.invalidate();
            MainApplication.getLayerManager().setActiveLayer((Layer)AutoCalibrateHandler.this.currentPicLayer);
            AutoCalibrateHandler.this.mainWindow.setVisible(false);
            ResultCheckView checkView = new ResultCheckView();
            int selectedValue = checkView.showAndChoose();
            if (selectedValue == 1) {
                AutoCalibrateHandler.this.currentPicLayer.getTransformer().resetCalibration();
                AutoCalibrateHandler.this.currentPicLayer.invalidate();
            }
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCalibrateHandler.this.reset();
            AutoCalibrateHandler.this.removeListChangedListener();
        }
    }

    private class SelectLayerButtonListener
    implements ActionListener {
        private SelectLayerView selector;

        private SelectLayerButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AutoCalibrateHandler.this.mainWindow.setVisible(false);
            this.selector = new SelectLayerView();
            this.selector.setVisible(true);
            this.selector.setOkButtonListener(new SelectorOkButtonListener());
            this.selector.setCancelButtonListener(new SelectorCancelButtonListener());
        }

        private class SelectorOkButtonListener
        implements ActionListener {
            private SelectorOkButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = (String)SelectLayerButtonListener.this.selector.getList().getSelectedValue();
                if (filename != null) {
                    for (Layer l : MainApplication.getLayerManager().getLayers()) {
                        if (!l.getName().equals(filename)) continue;
                        AutoCalibrateHandler.this.referenceLayer = l;
                        MainApplication.getLayerManager().setActiveLayer(l);
                    }
                }
                if (AutoCalibrateHandler.this.referenceLayer != null) {
                    AutoCalibrateHandler.this.mainWindow.setReferenceFileNameValue(filename);
                } else {
                    AutoCalibrateHandler.this.calibrator.showErrorView(CalibrationErrorView.SELECT_LAYER_ERROR);
                }
                SelectLayerButtonListener.this.selector.setVisible(false);
                AutoCalibrateHandler.this.mainWindow.setVisible(true);
            }
        }

        private class SelectorCancelButtonListener
        implements ActionListener {
            private SelectorCancelButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectLayerButtonListener.this.selector.getFrame().dispatchEvent(new WindowEvent(SelectLayerButtonListener.this.selector.getFrame(), 201));
            }
        }
    }

    private class OpenFileButtonListener
    implements ActionListener {
        private JButton openButton;
        private JFileChooser fileChooser;

        private OpenFileButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int openValue;
            AutoCalibrateHandler.this.mainWindow.setVisible(false);
            this.openButton = AutoCalibrateHandler.this.mainWindow.getOpenButton();
            this.fileChooser = AutoCalibrateHandler.this.mainWindow.getFileChooser();
            if (event.getSource() == this.openButton && (openValue = this.fileChooser.showOpenDialog(AutoCalibrateHandler.this.mainWindow)) == 0) {
                AutoCalibrateHandler.this.referenceFile = this.fileChooser.getSelectedFile();
                AutoCalibrateHandler.this.addFileInNewLayer(AutoCalibrateHandler.this.referenceFile);
            }
            if (AutoCalibrateHandler.this.referenceFile != null) {
                AutoCalibrateHandler.this.mainWindow.setReferenceFileNameValue(AutoCalibrateHandler.this.referenceFile.getName());
                AutoCalibrateHandler.this.mainWindow.setVisible(true);
            }
            AutoCalibrateHandler.this.mainWindow.setVisible(true);
        }
    }

    private static class HelpButtonListener
    implements ActionListener {
        private HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String topic = "Plugin/PicLayer";
            HelpBrowser.setUrlForHelpTopic((String)Optional.ofNullable(topic).orElse("/"));
        }
    }
}

