/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ExceptValueModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class NonStandardExceptWarning
extends Issue {
    private ExceptValueModel value;

    public NonStandardExceptWarning(IssuesModel parent, ExceptValueModel value) {
        super(parent, Severity.WARNING);
        this.actions.add(new FixInEditorAction());
        this.value = value;
    }

    @Override
    public String getText() {
        return I18n.tr((String)"The tag <tt>except</tt> has the non-standard value <tt>{0}</tt>. It is recommended to use standard values for <tt>except</tt> only.", (Object[])new Object[]{this.value.getValue()});
    }

    class FixInEditorAction
    extends AbstractAction {
        FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Go to Basic Editor and select standard vehicle type based exceptions", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NonStandardExceptWarning.this.getIssuesModel().getNavigationControler().gotoBasicEditor();
        }
    }
}

