/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.changeset.Changeset;
import org.openstreetmap.josm.plugins.changeset.util.CellRenderer;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetBeen;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetController;
import org.openstreetmap.josm.plugins.changeset.util.Config;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public final class ChangesetDialog
extends ToggleDialog
implements ActionListener {
    private MapView mv;
    private final JPanel jContentPanel;
    private final JPanel jPanelProjects;
    private final JPanel jPanelOptions;
    private final JButton jButtonGetChangesets;
    private final JButton jButtonNext;
    private final JButton jButtonprevious;
    private final SideButton displayChangesetButton;
    private final SideButton OpenChangesetweb;
    private final JTextField jTextFieldChangesetId;
    private final ChangesetController changesetController;
    Changeset changeset;
    private final ListCellRenderer<ChangesetBeen> renderer;
    private final JComboBox<ChangesetBeen> jComboBox;
    private boolean flag;

    public ChangesetDialog() {
        super(I18n.tr((String)"Changeset viewer", (Object[])new Object[0]), "changeset", I18n.tr((String)"Open changeset Viewer window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Tool:changeset-viewer", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Tool:changeset-Viewer", (Object[])new Object[0])}), (int)84, (int)5010), 120);
        this.mv = MainApplication.getMap().mapView;
        this.jContentPanel = new JPanel(new GridLayout(1, 1));
        this.jPanelProjects = new JPanel(new GridLayout(4, 1));
        this.jPanelOptions = new JPanel(new GridLayout(1, 2));
        this.jButtonGetChangesets = new JButton(I18n.tr((String)"Get changeset in the area", (Object[])new Object[0]));
        this.jButtonNext = new JButton(I18n.tr((String)"Next ->", (Object[])new Object[0]));
        this.jButtonprevious = new JButton(I18n.tr((String)"<- Previous", (Object[])new Object[0]));
        this.changesetController = new ChangesetController();
        this.changeset = new Changeset();
        this.renderer = new CellRenderer();
        this.jComboBox = new JComboBox();
        this.flag = true;
        this.jPanelProjects.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanelProjects.add(this.jButtonGetChangesets);
        this.jButtonprevious.setEnabled(false);
        this.jButtonNext.setEnabled(false);
        this.jButtonGetChangesets.addActionListener(e -> {
            this.flag = false;
            Config.setPAGE(1);
            Bounds bounds = this.mv.getRealBounds();
            String bbox = String.valueOf(bounds.getMinLon()) + "," + String.valueOf(bounds.getMinLat()) + "," + String.valueOf(bounds.getMaxLon()) + "," + String.valueOf(bounds.getMaxLat());
            Config.setBBOX(bbox);
            this.getChangesets();
            this.jButtonNext.setEnabled(true);
        });
        this.jButtonprevious.addActionListener(e -> {
            this.flag = false;
            if (Config.getPAGE() > 1) {
                Config.setPAGE(Config.getPAGE() - 1);
                this.getChangesets();
            }
        });
        this.jButtonNext.addActionListener(e -> {
            this.jButtonprevious.setEnabled(true);
            this.flag = false;
            Config.setPAGE(Config.getPAGE() + 1);
            this.getChangesets();
        });
        this.jComboBox.addActionListener(this);
        this.jPanelProjects.add(this.jComboBox);
        this.jPanelOptions.add(this.jButtonprevious);
        this.jPanelOptions.add(this.jButtonNext);
        this.jPanelProjects.add(this.jPanelOptions);
        this.jTextFieldChangesetId = new JTextField("55006771");
        this.jPanelProjects.add(this.jTextFieldChangesetId);
        this.jContentPanel.add(this.jPanelProjects);
        this.displayChangesetButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Display changeset", (Object[])new Object[0]));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", I18n.tr((String)"Display changeset", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    ChangesetDialog.this.printMap(ChangesetDialog.this.jTextFieldChangesetId.getText());
                } else {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Fill a changeset id!", (Object[])new Object[0]));
                }
            }
        });
        this.OpenChangesetweb = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Open in OSM", (Object[])new Object[0]));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", I18n.tr((String)"Open in OSM", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    OpenBrowser.displayUrl((String)("https://www.openstreetmap.org/changeset/" + ChangesetDialog.this.jTextFieldChangesetId.getText()));
                } else {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Fill a changeset id!", (Object[])new Object[0]));
                }
            }
        });
        this.createLayout(this.jContentPanel, false, Arrays.asList(this.displayChangesetButton, this.OpenChangesetweb));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ChangesetBeen ch = (ChangesetBeen)this.jComboBox.getSelectedItem();
        if (ch != null && this.flag) {
            this.jTextFieldChangesetId.setText(String.valueOf(ch.getChangesetId()));
            this.printMap(String.valueOf(ch.getChangesetId()));
        }
        this.flag = true;
    }

    private void getChangesets() {
        ChangesetBeen[] elements;
        this.jComboBox.removeAllItems();
        for (ChangesetBeen element : elements = this.changesetController.getListChangeset()) {
            this.jComboBox.addItem(element);
        }
        this.jComboBox.setRenderer(this.renderer);
    }

    public void printMap(String ChangesetId) {
        DataSetChangesetBuilder.BoundedChangesetDataSet boundedDataSet = this.changesetController.getChangeset(ChangesetId);
        if (boundedDataSet == null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Check the right changeset Id, if it is ok, maybe the changeset was not processed yet, try again in few minutes!", (Object[])new Object[0]));
        } else {
            this.changeset.work(boundedDataSet, ChangesetId);
        }
    }
}

