/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.history.StreetsideRecordListener;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideExecutableCommand;

public class StreetsideRecord {
    private static StreetsideRecord instance;
    private final List<StreetsideRecordListener> listeners = new ArrayList<StreetsideRecordListener>();
    public List<StreetsideCommand> commandList = new ArrayList<StreetsideCommand>();
    public int position = -1;

    public static synchronized StreetsideRecord getInstance() {
        if (instance == null) {
            instance = new StreetsideRecord();
        }
        return instance;
    }

    public void addListener(StreetsideRecordListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(StreetsideRecordListener lis) {
        this.listeners.remove(lis);
    }

    public void addCommand(StreetsideCommand command) {
        if (command instanceof StreetsideExecutableCommand) {
            ((StreetsideExecutableCommand)command).execute();
        }
        if (this.position != -1) {
            boolean equalSets = true;
            for (StreetsideAbstractImage img : this.commandList.get((int)this.position).images) {
                equalSets = command.images.contains(img) && equalSets;
            }
            for (StreetsideAbstractImage img : command.images) {
                equalSets = this.commandList.get((int)this.position).images.contains(img) && equalSets;
            }
            if (equalSets && this.commandList.get(this.position).getClass() == command.getClass()) {
                this.commandList.get(this.position).sum(command);
                this.fireRecordChanged();
                return;
            }
        }
        this.commandList.add(this.position + 1, command);
        ++this.position;
        while (this.commandList.size() > this.position + 1) {
            this.commandList.remove(this.position + 1);
        }
        this.fireRecordChanged();
    }

    public void undo() {
        if (this.position <= -1) {
            return;
        }
        this.commandList.get(this.position).undo();
        --this.position;
        this.fireRecordChanged();
    }

    public void redo() {
        if (this.position + 1 >= this.commandList.size()) {
            return;
        }
        ++this.position;
        this.commandList.get(this.position).redo();
        this.fireRecordChanged();
    }

    private void fireRecordChanged() {
        this.listeners.stream().filter(Objects::nonNull).forEach(StreetsideRecordListener::recordChanged);
    }

    public void reset() {
        this.commandList.clear();
        this.position = -1;
    }
}

