/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ObjectNode
extends ContainerNode<ObjectNode> {
    private final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    public ObjectNode deepCopy() {
        ObjectNode ret = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            ret._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return ret;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int index) {
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return this._children.get(fieldName);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String fieldName) {
        JsonNode n = this._children.get(fieldName);
        if (n != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            if (n instanceof ObjectNode) {
                return (ObjectNode)n;
            }
            throw new UnsupportedOperationException("Property '" + propertyName + "' has value that is not of type ObjectNode (but " + n.getClass().getName() + ")");
        }
        ObjectNode result = this.objectNode();
        this._children.put(propertyName, result);
        return result;
    }

    @Override
    public ArrayNode withArray(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            if (n instanceof ArrayNode) {
                return (ArrayNode)n;
            }
            throw new UnsupportedOperationException("Property '" + propertyName + "' has value that is not of type ArrayNode (but " + n.getClass().getName() + ")");
        }
        ArrayNode result = this.arrayNode();
        this._children.put(propertyName, result);
        return result;
    }

    @Override
    public JsonNode findValue(String fieldName) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode value = entry.getValue().findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add(entry.getValue());
                continue;
            }
            foundSoFar = entry.getValue().findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<String>();
                }
                foundSoFar.add(entry.getValue().asText());
                continue;
            }
            foundSoFar = entry.getValue().findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return this;
            }
            JsonNode value = entry.getValue().findParent(fieldName);
            if (value == null) continue;
            return (ObjectNode)value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add(this);
                continue;
            }
            foundSoFar = entry.getValue().findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartObject();
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            jg.writeFieldName(en.getKey());
            ((BaseJsonNode)en.getValue()).serialize(jg, provider);
        }
        jg.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(this, jg);
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            jg.writeFieldName(en.getKey());
            ((BaseJsonNode)en.getValue()).serialize(jg, provider);
        }
        typeSer.writeTypeSuffixForObject(this, jg);
    }

    public JsonNode set(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._children.put(fieldName, value);
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> properties) {
        for (Map.Entry<String, JsonNode> en : properties.entrySet()) {
            JsonNode n = en.getValue();
            if (n == null) {
                n = this.nullNode();
            }
            this._children.put(en.getKey(), n);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode other) {
        this._children.putAll(other._children);
        return this;
    }

    public JsonNode replace(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(fieldName, value);
    }

    public JsonNode without(String fieldName) {
        this._children.remove(fieldName);
        return this;
    }

    public ObjectNode without(Collection<String> fieldNames) {
        this._children.keySet().removeAll(fieldNames);
        return this;
    }

    public JsonNode put(String fieldName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(fieldName, value);
    }

    public JsonNode remove(String fieldName) {
        return this._children.remove(fieldName);
    }

    public ObjectNode remove(Collection<String> fieldNames) {
        this._children.keySet().removeAll(fieldNames);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> properties) {
        return this.setAll(properties);
    }

    public JsonNode putAll(ObjectNode other) {
        return this.setAll(other);
    }

    public ObjectNode retain(Collection<String> fieldNames) {
        this._children.keySet().retainAll(fieldNames);
        return this;
    }

    public ObjectNode retain(String ... fieldNames) {
        return this.retain(Arrays.asList(fieldNames));
    }

    public ArrayNode putArray(String fieldName) {
        ArrayNode n = this.arrayNode();
        this._children.put(fieldName, n);
        return n;
    }

    public ObjectNode putObject(String fieldName) {
        ObjectNode n = this.objectNode();
        this._children.put(fieldName, n);
        return n;
    }

    public ObjectNode putPOJO(String fieldName, Object pojo) {
        this._children.put(fieldName, this.pojoNode(pojo));
        return this;
    }

    public ObjectNode putNull(String fieldName) {
        this._children.put(fieldName, this.nullNode());
        return this;
    }

    public ObjectNode put(String fieldName, short v) {
        this._children.put(fieldName, this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Short value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.numberNode((short)value));
        }
        return this;
    }

    public ObjectNode put(String fieldName, int v) {
        this._children.put(fieldName, this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Integer value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.numberNode((int)value));
        }
        return this;
    }

    public ObjectNode put(String fieldName, long v) {
        this._children.put(fieldName, this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Long value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.numberNode((long)value));
        }
        return this;
    }

    public ObjectNode put(String fieldName, float v) {
        this._children.put(fieldName, this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Float value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.numberNode(value.floatValue()));
        }
        return this;
    }

    public ObjectNode put(String fieldName, double v) {
        this._children.put(fieldName, this.numberNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Double value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.numberNode((double)value));
        }
        return this;
    }

    public ObjectNode put(String fieldName, BigDecimal v) {
        if (v == null) {
            this.putNull(fieldName);
        } else {
            this._children.put(fieldName, this.numberNode(v));
        }
        return this;
    }

    public ObjectNode put(String fieldName, String v) {
        if (v == null) {
            this.putNull(fieldName);
        } else {
            this._children.put(fieldName, this.textNode(v));
        }
        return this;
    }

    public ObjectNode put(String fieldName, boolean v) {
        this._children.put(fieldName, this.booleanNode(v));
        return this;
    }

    public ObjectNode put(String fieldName, Boolean value) {
        if (value == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.booleanNode(value));
        }
        return this;
    }

    public ObjectNode put(String fieldName, byte[] v) {
        if (v == null) {
            this._children.put(fieldName, this.nullNode());
        } else {
            this._children.put(fieldName, this.binaryNode(v));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this._children.equals(((ObjectNode)o)._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32 + (this.size() << 4));
        sb.append("{");
        int count = 0;
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            if (count > 0) {
                sb.append(",");
            }
            ++count;
            TextNode.appendQuoted(sb, en.getKey());
            sb.append(':');
            sb.append(en.getValue().toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

