/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public class JacksonDeserializers {
    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{JavaTypeDeserializer.instance, TokenBufferDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> rawType) {
        if (rawType == TokenBuffer.class) {
            return TokenBufferDeserializer.instance;
        }
        if (JavaType.class.isAssignableFrom(rawType)) {
            return JavaTypeDeserializer.instance;
        }
        return null;
    }

    public static ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc) {
        if (beanDesc.getBeanClass() == JsonLocation.class) {
            return JsonLocationInstantiator.instance;
        }
        return null;
    }

    @JacksonStdImpl
    public static class TokenBufferDeserializer
    extends StdScalarDeserializer<TokenBuffer> {
        public static final TokenBufferDeserializer instance = new TokenBufferDeserializer();

        public TokenBufferDeserializer() {
            super(TokenBuffer.class);
        }

        @Override
        public TokenBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TokenBuffer tb = new TokenBuffer(jp.getCodec());
            tb.copyCurrentStructure(jp);
            return tb;
        }
    }

    public static class JsonLocationInstantiator
    extends ValueInstantiator {
        public static final JsonLocationInstantiator instance = new JsonLocationInstantiator();

        @Override
        public String getValueTypeDesc() {
            return JsonLocation.class.getName();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return true;
        }

        public CreatorProperty[] getFromObjectArguments(DeserializationConfig config) {
            JavaType intType = config.constructType(Integer.TYPE);
            JavaType longType = config.constructType(Long.TYPE);
            return new CreatorProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", longType, 1), JsonLocationInstantiator.creatorProp("charOffset", longType, 2), JsonLocationInstantiator.creatorProp("lineNr", intType, 3), JsonLocationInstantiator.creatorProp("columnNr", intType, 4)};
        }

        private static CreatorProperty creatorProp(String name, JavaType type, int index) {
            return new CreatorProperty(name, type, null, null, null, null, index, null, true);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
            return new JsonLocation(args[0], JsonLocationInstantiator._long(args[1]), JsonLocationInstantiator._long(args[2]), JsonLocationInstantiator._int(args[3]), JsonLocationInstantiator._int(args[4]));
        }

        private static final long _long(Object o) {
            return o == null ? 0L : ((Number)o).longValue();
        }

        private static final int _int(Object o) {
            return o == null ? 0 : ((Number)o).intValue();
        }
    }

    public static class JavaTypeDeserializer
    extends StdScalarDeserializer<JavaType> {
        public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

        public JavaTypeDeserializer() {
            super(JavaType.class);
        }

        @Override
        public JavaType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken curr = jp.getCurrentToken();
            if (curr == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return (JavaType)this.getEmptyValue();
                }
                return ctxt.getTypeFactory().constructFromCanonical(str);
            }
            if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (JavaType)jp.getEmbeddedObject();
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }
}

