/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.o5m.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class O5mReader
extends AbstractReader {
    private IllegalDataException exception;
    private boolean discourageUpload;
    private static final int NODE_DATASET = 16;
    private static final int WAY_DATASET = 17;
    private static final int REL_DATASET = 18;
    private static final int BBOX_DATASET = 219;
    private static final int TIMESTAMP_DATASET = 220;
    private static final int HEADER_DATASET = 224;
    private static final int EOD_FLAG = 254;
    private static final int RESET_FLAG = 255;
    private static final int EOF_FLAG = -1;
    private static final int STRING_TABLE_SIZE = 15000;
    private static final int MAX_STRING_PAIR_SIZE = 252;
    private static final String[] REL_REF_TYPES = new String[]{"node", "way", "relation", "?"};
    private static final double FACTOR = 1.0E-9;
    private BufferedInputStream fis;
    private InputStream is;
    private byte[] cnvBuffer = new byte[4000];
    private byte[] ioBuf = new byte[8192];
    private int ioBufPos = 0;
    private String[][] stringTable;
    private String[] stringPair = new String[2];
    private int currStringTablePos;
    private int bytesToRead;
    private long countBytes;
    private long lastNodeId;
    private long lastWayId;
    private long lastRelId;
    private long[] lastRef = new long[3];
    private long lastTs;
    private long lastChangeSet;
    private int lastLon;
    private int lastLat;
    private int version;
    private User osmUser;
    private String header;

    private static void checkCoordinates(LatLon coor) throws IllegalDataException {
        if (!coor.isValid()) {
            throw new IllegalDataException(I18n.tr((String)"Invalid coordinates: {0}", (Object[])new Object[]{coor}));
        }
    }

    private static void checkChangesetId(long id) throws IllegalDataException {
        if (id > Integer.MAX_VALUE) {
            throw new IllegalDataException(I18n.tr((String)"Invalid changeset id: {0}", (Object[])new Object[]{id}));
        }
    }

    private static void checkTimestamp(long timestamp) throws IllegalDataException {
        if (timestamp < 0L) {
            throw new IllegalDataException(I18n.tr((String)"Invalid timestamp: {0}", (Object[])new Object[]{timestamp}));
        }
    }

    O5mReader() {
        this.reset();
    }

    public void parse(InputStream source) throws ParsingCancelException {
        this.fis = new BufferedInputStream(source);
        this.is = this.fis;
        try {
            int start = this.is.read();
            ++this.countBytes;
            if (start != 255) {
                throw new IOException(I18n.tr((String)"wrong header byte ", (Object[])new Object[0]) + Integer.toHexString(start));
            }
            this.readFile();
            if (this.discourageUpload) {
                this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
    }

    private void readFile() throws IOException, ParsingCancelException {
        boolean done = false;
        while (!done) {
            if (this.cancel) {
                this.cancel = false;
                throw new ParsingCancelException(I18n.tr((String)"Reading was canceled at file offset {0}", (Object[])new Object[]{this.countBytes}));
            }
            this.is = this.fis;
            long size = 0L;
            int fileType = this.is.read();
            ++this.countBytes;
            if (fileType >= 0 && fileType < 240) {
                this.bytesToRead = 0;
                size = this.readUnsignedNum64FromStream();
                this.countBytes += size - (long)this.bytesToRead;
                this.bytesToRead = (int)size;
                switch (fileType) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 219: 
                    case 220: 
                    case 224: {
                        this.is = this.fillByteArray();
                        break;
                    }
                }
            }
            if (fileType == -1) {
                done = true;
                continue;
            }
            if (fileType == 16) {
                this.readNode();
                continue;
            }
            if (fileType == 17) {
                this.readWay();
                continue;
            }
            if (fileType == 18) {
                this.readRel();
                continue;
            }
            if (fileType == 219) {
                this.readBBox();
                continue;
            }
            if (fileType == 220) {
                this.readFileTimestamp();
                continue;
            }
            if (fileType == 224) {
                this.readHeader();
                continue;
            }
            if (fileType == 254) {
                done = true;
                continue;
            }
            if (fileType == 255) {
                this.reset();
                continue;
            }
            if (fileType >= 240) continue;
            this.skip(size);
        }
    }

    private InputStream fillByteArray() throws IOException {
        if (this.bytesToRead > this.ioBuf.length) {
            this.ioBuf = new byte[this.bytesToRead + 100];
        }
        int bytesRead = 0;
        for (int neededBytes = this.bytesToRead; neededBytes > 0; neededBytes -= bytesRead) {
            bytesRead += this.is.read(this.ioBuf, bytesRead, neededBytes);
        }
        this.ioBufPos = 0;
        return new ByteArrayInputStream(this.ioBuf, 0, this.bytesToRead);
    }

    private void readFileTimestamp() {
        this.readSignedNum64();
    }

    private void skip(long bytes) throws IOException {
        for (long toSkip = bytes; toSkip > 0L; toSkip -= this.is.skip(toSkip)) {
        }
    }

    private void readBBox() {
        double minlon = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double minlat = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double maxlon = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double maxlat = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        Bounds b = new Bounds(minlat, minlon, maxlat, maxlon);
        if (!b.isCollapsed() && LatLon.isValidLat((double)minlat) && LatLon.isValidLat((double)maxlat) && LatLon.isValidLon((double)minlon) && LatLon.isValidLon((double)maxlon)) {
            this.ds.addDataSource(new DataSource(b, this.header));
        } else {
            Logging.error((String)("Invalid Bounds: " + b));
        }
    }

    private void setMeta(PrimitiveData pd) throws IllegalDataException {
        pd.setVersion(this.version == 0 ? 1 : this.version);
        O5mReader.checkChangesetId(this.lastChangeSet);
        pd.setChangesetId((int)this.lastChangeSet);
        if (this.lastTs != 0L) {
            O5mReader.checkTimestamp(this.lastTs);
            pd.setTimestamp(new Date(this.lastTs * 1000L));
            if (this.osmUser != null) {
                pd.setUser(this.osmUser);
            }
        }
    }

    private void readNode() {
        if (this.exception != null) {
            return;
        }
        try {
            int lat;
            int lon;
            this.lastNodeId += this.readSignedNum64();
            if (this.bytesToRead == 0) {
                return;
            }
            this.readVersionTsAuthor();
            if (this.bytesToRead == 0) {
                return;
            }
            this.lastLon = lon = this.readSignedNum32() + this.lastLon;
            this.lastLat = lat = this.readSignedNum32() + this.lastLat;
            double flon = 1.0E-9 * (double)(100L * (long)lon);
            double flat = 1.0E-9 * (double)(100L * (long)lat);
            assert (flat >= -90.0 && flat <= 90.0);
            assert (flon >= -180.0 && flon <= 180.0);
            if (this.version == 0) {
                this.discourageUpload = true;
            }
            NodeData nd = new NodeData(this.lastNodeId);
            nd.setCoor(new LatLon(flat, flon).getRoundedToOsmPrecision());
            O5mReader.checkCoordinates(nd.getCoor());
            this.setMeta((PrimitiveData)nd);
            if (this.bytesToRead > 0) {
                Map<String, String> keys = this.readTags();
                nd.setKeys(keys);
            }
            this.buildPrimitive((PrimitiveData)nd);
        }
        catch (IllegalDataException e) {
            this.exception = e;
        }
    }

    private void readWay() {
        if (this.exception != null) {
            return;
        }
        try {
            this.lastWayId += this.readSignedNum64();
            if (this.bytesToRead == 0) {
                return;
            }
            this.readVersionTsAuthor();
            if (this.bytesToRead == 0) {
                return;
            }
            if (this.version == 0) {
                this.discourageUpload = true;
            }
            WayData wd = new WayData(this.lastWayId);
            this.setMeta((PrimitiveData)wd);
            long refSize = this.readUnsignedNum32();
            long stop = (long)this.bytesToRead - refSize;
            ArrayList<Long> nodeIds = new ArrayList<Long>();
            while ((long)this.bytesToRead > stop) {
                this.lastRef[0] = this.lastRef[0] + this.readSignedNum64();
                nodeIds.add(this.lastRef[0]);
            }
            Map<String, String> keys = this.readTags();
            wd.setKeys(keys);
            this.ways.put(wd.getUniqueId(), nodeIds);
            this.buildPrimitive((PrimitiveData)wd);
        }
        catch (IllegalDataException e) {
            this.exception = e;
        }
    }

    private void readRel() {
        if (this.exception != null) {
            return;
        }
        try {
            this.lastRelId += this.readSignedNum64();
            if (this.bytesToRead == 0) {
                return;
            }
            this.readVersionTsAuthor();
            if (this.bytesToRead == 0) {
                return;
            }
            if (this.version == 0) {
                this.discourageUpload = true;
            }
            RelationData rel = new RelationData(this.lastRelId);
            this.setMeta((PrimitiveData)rel);
            long refSize = this.readUnsignedNum32();
            long stop = (long)this.bytesToRead - refSize;
            ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>();
            while ((long)this.bytesToRead > stop) {
                long deltaRef = this.readSignedNum64();
                int refType = this.readRelRef();
                String role = this.stringPair[1];
                int n = refType;
                this.lastRef[n] = this.lastRef[n] + deltaRef;
                long memId = this.lastRef[refType];
                OsmPrimitiveType type = null;
                if (refType == 0) {
                    type = OsmPrimitiveType.NODE;
                } else if (refType == 1) {
                    type = OsmPrimitiveType.WAY;
                } else if (refType == 2) {
                    type = OsmPrimitiveType.RELATION;
                }
                members.add(new RelationMemberData(role, type, memId));
            }
            Map<String, String> keys = this.readTags();
            rel.setKeys(keys);
            this.relations.put(rel.getUniqueId(), members);
            this.buildPrimitive((PrimitiveData)rel);
        }
        catch (IllegalDataException e) {
            this.exception = e;
        }
    }

    private Map<String, String> readTags() {
        HashMap<String, String> keys = new HashMap<String, String>();
        while (this.bytesToRead > 0) {
            this.readStringPair();
            keys.put(this.stringPair[0], this.stringPair[1]);
        }
        assert (this.bytesToRead == 0);
        return keys;
    }

    private void storeStringPair() {
        this.stringTable[0][this.currStringTablePos] = this.stringPair[0];
        this.stringTable[1][this.currStringTablePos] = this.stringPair[1];
        ++this.currStringTablePos;
        if (this.currStringTablePos >= 15000) {
            this.currStringTablePos = 0;
        }
    }

    private void setStringRefPair(int ref) {
        int pos = this.currStringTablePos - ref;
        if (pos < 0) {
            pos += 15000;
        }
        this.stringPair[0] = this.stringTable[0][pos];
        this.stringPair[1] = this.stringTable[1][pos];
    }

    private void readVersionTsAuthor() {
        this.stringPair[0] = null;
        this.stringPair[1] = null;
        this.version = this.readUnsignedNum32();
        if (this.version != 0) {
            long ts;
            this.lastTs = ts = this.readSignedNum64() + this.lastTs;
            if (ts != 0L) {
                long changeSet;
                this.lastChangeSet = changeSet = (long)this.readSignedNum32() + this.lastChangeSet;
                this.readAuthor();
            }
        }
    }

    private void readAuthor() {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            long uidNum = this.readUnsignedNum64();
            if (uidNum == 0L) {
                this.stringPair[0] = "";
            } else {
                this.stringPair[0] = Long.toUnsignedString(uidNum);
                ++this.ioBufPos;
                --this.bytesToRead;
            }
            int start = 0;
            int buffPos = 0;
            this.stringPair[1] = null;
            while (this.stringPair[1] == null) {
                byte b = this.ioBuf[this.ioBufPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[1] = new String(this.cnvBuffer, start, buffPos - 1, StandardCharsets.UTF_8);
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
        if (this.stringPair[0] != null && !this.stringPair[0].isEmpty()) {
            long uid = Long.parseLong(this.stringPair[0]);
            this.osmUser = User.createOsmUser((long)uid, (String)this.stringPair[1]);
        } else {
            this.osmUser = null;
        }
    }

    private int readRelRef() {
        int refType = -1;
        long toReadStart = this.bytesToRead;
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            refType = this.ioBuf[this.ioBufPos++] - 48;
            --this.bytesToRead;
            if (refType < 0 || refType > 2) {
                refType = 3;
            }
            this.stringPair[0] = REL_REF_TYPES[refType];
            int start = 0;
            int buffPos = 0;
            this.stringPair[1] = null;
            while (this.stringPair[1] == null) {
                byte b = this.ioBuf[this.ioBufPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[1] = new String(this.cnvBuffer, start, buffPos - 1, StandardCharsets.UTF_8);
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
            char c = this.stringPair[0].charAt(0);
            switch (c) {
                case 'n': {
                    refType = 0;
                    break;
                }
                case 'w': {
                    refType = 1;
                    break;
                }
                case 'r': {
                    refType = 2;
                    break;
                }
                default: {
                    refType = 3;
                }
            }
        }
        return refType;
    }

    private void readStringPair() {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            int cnt = 0;
            int buffPos = 0;
            int start = 0;
            while (cnt < 2) {
                byte b = this.ioBuf[this.ioBufPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[cnt] = new String(this.cnvBuffer, start, buffPos - start - 1, StandardCharsets.UTF_8);
                ++cnt;
                start = buffPos;
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private void reset() {
        this.lastNodeId = 0L;
        this.lastWayId = 0L;
        this.lastRelId = 0L;
        this.lastRef[0] = 0L;
        this.lastRef[1] = 0L;
        this.lastRef[2] = 0L;
        this.lastTs = 0L;
        this.lastChangeSet = 0L;
        this.lastLon = 0;
        this.lastLat = 0;
        this.stringTable = new String[2][15000];
        this.currStringTablePos = 0;
    }

    private void readHeader() throws IOException {
        if (this.ioBuf[0] != 111 || this.ioBuf[1] != 53 || this.ioBuf[2] != 99 && this.ioBuf[2] != 109 || this.ioBuf[3] != 50) {
            throw new IOException(I18n.tr((String)"unsupported header", (Object[])new Object[0]));
        }
        this.header = new String(this.ioBuf, 0, 3, StandardCharsets.UTF_8);
    }

    private int readSignedNum32() {
        return (int)this.readSignedNum64();
    }

    private long readSignedNum64() {
        byte b = this.ioBuf[this.ioBufPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1L - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7EL) >> 1;
        int shift = 6;
        while (((b = this.ioBuf[this.ioBufPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        result += (long)b << shift;
        if (sign == 1) {
            return -1L - result;
        }
        return result;
    }

    private long readUnsignedNum64FromStream() throws IOException {
        int b = this.is.read();
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        int shift = 7;
        while (((b = this.is.read()) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        return result += (long)b << shift;
    }

    private long readUnsignedNum64() {
        byte b = this.ioBuf[this.ioBufPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        int shift = 7;
        while (((b = this.ioBuf[this.ioBufPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        return result += (long)b << shift;
    }

    private int readUnsignedNum32() {
        return (int)this.readUnsignedNum64();
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        return new O5mReader().doParseDataSet(source, progressMonitor);
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        ProgressMonitor.CancelListener cancelListener = () -> {
            this.cancel = true;
        };
        progressMonitor.addCancelListener(cancelListener);
        try {
            progressMonitor.beginTask(I18n.tr((String)"Prepare OSM data...", (Object[])new Object[0]), 3);
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Reading OSM data...", (Object[])new Object[0]));
            this.parse(source);
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Preparing data set...", (Object[])new Object[0]));
            this.prepareDataSet();
            progressMonitor.worked(1);
            if (this.cancel) {
                throw new ParsingCancelException(I18n.tr((String)"Import was canceled", (Object[])new Object[0]));
            }
            DataSet dataSet = this.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalDataException((Throwable)e);
        }
        finally {
            progressMonitor.finishTask();
            progressMonitor.removeCancelListener(cancelListener);
        }
    }

    private static final class ParsingCancelException
    extends Exception
    implements ImportCancelException {
        private static final long serialVersionUID = 1L;

        ParsingCancelException(String msg) {
            super(msg);
        }
    }
}

