/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.preferences.projection.CodeProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.CustomProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.projection.SingleProjectionChoice;
import org.openstreetmap.josm.plugins.pdfimport.GuiPanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GuiProjections {
    private GuiPanel panel = null;
    private Chooser chooser = null;
    private JLabel pCode = null;
    private JLabel pName = null;
    private JLabel pInfo = null;
    private Projection projection = null;

    public GuiProjections() {
        this.build();
    }

    public static String getDefault() {
        return Config.getPref().get("projection.default");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection p) {
        this.chooser.setProjection(p);
    }

    private String userHints(Projection p) {
        String s = "";
        try {
            ProjectionBounds bd = p.getWorldBoundsBoxEastNorth();
            s = s + String.format("(%3$.0f %4$.0f) : (%5$.0f %6$.0f)", bd.getCenter().east(), bd.getCenter().north(), bd.getMin().east(), bd.getMin().north(), bd.getMax().east(), bd.getMax().north());
        }
        catch (Exception e) {
            e.toString();
        }
        return s;
    }

    private void build() {
        this.pCode = new JLabel("code", 4);
        this.pName = new JLabel("Name", 4);
        this.pInfo = new JLabel("Info", 4);
        this.chooser = new Chooser();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 4);
        c.anchor = 22;
        this.panel = new GuiPanel(new GridBagLayout());
        this.panel.add((Component)new JLabel(I18n.tr((String)"Projection:", (Object[])new Object[0]), 4), c);
        this.panel.add((Component)this.pCode, c);
        c.weightx = 1.0;
        c.gridx = 2;
        this.panel.add((Component)this.chooser, c);
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 3;
        c.anchor = 22;
        this.panel.add((Component)this.pInfo, c);
    }

    private class Chooser
    extends JComboBox<ProjectionChoice> {
        public Chooser() {
            this.setEditable(false);
            this.setToolTipText(I18n.tr((String)"Projection of the PDF-Document", (Object[])new Object[0]));
            Monitor monitor = new Monitor();
            for (ProjectionChoice p : ProjectionPreference.getProjectionChoices()) {
                if (p instanceof CodeProjectionChoice || p instanceof CustomProjectionChoice) continue;
                this.addItem(p);
            }
            this.addActionListener(monitor);
            this.setProjection(ProjectionRegistry.getProjection());
        }

        public void setProjection(Projection p) {
            if (p == null) {
                return;
            }
            GuiProjections.this.projection = p;
            GuiProjections.this.pName.setText(p.toString());
            GuiProjections.this.pCode.setText(p.toCode());
            GuiProjections.this.pInfo.setText(GuiProjections.this.userHints(p));
            String projectionCode = p.toCode();
            for (ProjectionChoice projectionChoice : ProjectionPreference.getProjectionChoices()) {
                for (String code : projectionChoice.allCodes()) {
                    if (!code.equals(projectionCode)) continue;
                    this.setSelectedItem(projectionChoice);
                    return;
                }
            }
            String localId = "PdfImport:" + projectionCode;
            for (int i = this.getItemCount() - 1; i >= 0; --i) {
                ProjectionChoice projectionChoice = (ProjectionChoice)this.getItemAt(i);
                if (!(projectionChoice instanceof SingleProjectionChoice) || !localId.equals(projectionChoice.getId())) continue;
                this.setSelectedItem(projectionChoice);
                return;
            }
            Logging.debug((String)"New projection encountered");
            SingleProjectionChoice px = new SingleProjectionChoice(p.toString(), localId, projectionCode);
            this.addItem(px);
            this.setSelectedItem(px);
        }

        private class Monitor
        implements ActionListener {
            private Monitor() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProjectionChoice pc = (ProjectionChoice)((Chooser)e.getSource()).getSelectedItem();
                    Chooser.this.setProjection(pc.getProjection());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

