/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldString;

public class GuiFieldHex
extends GuiFieldString {
    private int value;
    public CheckHex checker = new CheckHex();

    public GuiFieldHex() {
        this.addFocusListener(this.checker);
        this.setValue(0);
    }

    public GuiFieldHex(String text) {
        super(text);
        this.addFocusListener(this.checker);
    }

    public GuiFieldHex(int v) {
        this.addFocusListener(this.checker);
        this.setValue(v);
    }

    public void setValue(int v) {
        super.setText("#" + Integer.toHexString(v));
        this.value = v;
        this.checker.check(this);
    }

    public int getValue() throws NumberFormatException {
        if (!this.dataValid) {
            throw new NumberFormatException();
        }
        return this.value;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checker.check(this);
    }

    public class CheckHex
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.check((GuiFieldHex)event.getSource());
        }

        public void check(GuiFieldHex field) {
            try {
                GuiFieldHex.this.value = Integer.decode(field.getText());
                GuiFieldHex.this.dataValid = true;
                field.setBorder(GuiFieldHex.this.defaultBorder);
            }
            catch (NumberFormatException e) {
                field.setBorder(BorderFactory.createLineBorder(Color.red));
                GuiFieldHex.this.dataValid = false;
            }
        }
    }
}

