/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.pdfimport.FilePlacement;
import org.openstreetmap.josm.plugins.pdfimport.GuiFieldDouble;
import org.openstreetmap.josm.plugins.pdfimport.GuiPanel;
import org.openstreetmap.josm.plugins.pdfimport.GuiProjections;
import org.openstreetmap.josm.plugins.pdfimport.ProjectionInfo;
import org.openstreetmap.josm.tools.I18n;

public class FilePlacement18
extends FilePlacement {
    private PlacementPanel panel = new PlacementPanel(this);
    private boolean valid = false;

    public boolean isValid() {
        return this.valid;
    }

    public void setDependsOnValid(JComponent c) {
        this.panel.setDependsOnValid(c);
    }

    public JPanel getGui() {
        if (this.panel == null) {
            this.panel = new PlacementPanel(this);
        }
        if (this.panel.panel == null) {
            this.panel.build();
        }
        return this.panel.panel;
    }

    public void load(File baseFile) throws IOException {
        File file = new File(baseFile + ".placement");
        Properties p = new Properties();
        try (FileInputStream s = new FileInputStream(file);){
            p.load(s);
            s.close();
        }
        this.fromProperties(p);
    }

    public void verify() {
        this.panel.Verify();
    }

    public void save(File baseFile) throws IOException {
        File file = new File(baseFile + ".placement");
        FileOutputStream s = new FileOutputStream(file);
        Properties p = this.toProperties();
        p.store(s, "PDF file placement on OSM");
        s.close();
    }

    private Projection getProjection(Properties p, String name) {
        String projectionCode = p.getProperty("Projection", null);
        if (projectionCode != null) {
            return ProjectionInfo.getProjectionByCode(p.getProperty("Projection", null));
        }
        return null;
    }

    private double getDouble(Properties p, String name, double defaultValue) {
        try {
            return Double.parseDouble(p.getProperty(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    protected void fromProperties(Properties p) {
        super.fromProperties(p);
        this.panel.load();
    }

    public class PlacementPanel {
        private GuiFieldDouble minXField;
        private GuiFieldDouble minYField;
        private GuiFieldDouble minEastField;
        private GuiFieldDouble minNorthField;
        private JButton getMinButton;
        private JButton getMaxButton;
        private GuiFieldDouble maxNorthField;
        private GuiFieldDouble maxEastField;
        private GuiFieldDouble maxYField;
        private GuiFieldDouble maxXField;
        private GuiPanel panel;
        private JLabel hintField;
        private CoorFields pdfMin;
        private CoorFields pdfMax;
        private CoorFields worldMin;
        private CoorFields worldMax;
        private GuiProjections projectionChooser;
        private FilePlacement18 fc = null;
        private JComponent dependsOnValid = null;

        public PlacementPanel(FilePlacement18 parrent) {
            if (parrent == null) {
                throw new IllegalArgumentException();
            }
            this.fc = parrent;
        }

        private PlacementPanel() {
        }

        void load() {
            try {
                this.minXField.setValue(this.fc.minX);
                this.maxXField.setValue(this.fc.maxX);
                this.minYField.setValue(this.fc.minY);
                this.maxYField.setValue(this.fc.maxY);
                this.minEastField.setValue(this.fc.minEast);
                this.maxEastField.setValue(this.fc.maxEast);
                this.minNorthField.setValue(this.fc.minNorth);
                this.maxNorthField.setValue(this.fc.maxNorth);
                this.projectionChooser.setProjection(this.fc.projection);
            }
            finally {
                this.Verify();
            }
        }

        void build() {
            Monitor monitor = new Monitor(this);
            this.projectionChooser = new GuiProjections();
            this.minXField = new GuiFieldDouble(0.0);
            this.minYField = new GuiFieldDouble(0.0);
            this.pdfMin = new CoorFields(this.minXField, this.minYField);
            this.minXField.setToolTipText(I18n.tr((String)"X-value of bottom left reference point", (Object[])new Object[0]));
            this.minXField.addFocusListener(monitor);
            this.minYField.setToolTipText(I18n.tr((String)"Y-value of bottom left reference point", (Object[])new Object[0]));
            this.minYField.addFocusListener(monitor);
            this.minEastField = new GuiFieldDouble(0.0);
            this.minNorthField = new GuiFieldDouble(0.0);
            this.worldMin = new CoorFields(this.minEastField, this.minNorthField);
            this.minEastField.setToolTipText(I18n.tr((String)"East-value of bottom left reference point", (Object[])new Object[0]));
            this.minEastField.addFocusListener(monitor);
            this.minNorthField.setToolTipText(I18n.tr((String)"North-value of bottom left reference point", (Object[])new Object[0]));
            this.minNorthField.addFocusListener(monitor);
            this.getMinButton = new JButton(I18n.tr((String)"Get from Preview", (Object[])new Object[0]));
            this.getMinButton.setToolTipText(I18n.tr((String)"Select a single node from preview", (Object[])new Object[0]));
            this.getMinButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlacementPanel.this.setFromCoor(PlacementPanel.this.pdfMin);
                }
            });
            this.maxXField = new GuiFieldDouble(1000.0);
            this.maxYField = new GuiFieldDouble(1000.0);
            this.pdfMax = new CoorFields(this.maxXField, this.maxYField);
            this.maxXField.setToolTipText(I18n.tr((String)"X-value of top right reference point", (Object[])new Object[0]));
            this.maxXField.addFocusListener(monitor);
            this.maxYField.setToolTipText(I18n.tr((String)"Y-value of top right  reference point", (Object[])new Object[0]));
            this.maxYField.addFocusListener(monitor);
            this.maxEastField = new GuiFieldDouble(1.0);
            this.maxNorthField = new GuiFieldDouble(1.0);
            this.worldMax = new CoorFields(this.maxEastField, this.maxNorthField);
            this.maxEastField.setToolTipText(I18n.tr((String)"East-value of top right reference point", (Object[])new Object[0]));
            this.maxEastField.addFocusListener(monitor);
            this.maxNorthField.setToolTipText(I18n.tr((String)"North-value of top right reference point", (Object[])new Object[0]));
            this.maxNorthField.addFocusListener(monitor);
            this.getMaxButton = new JButton(I18n.tr((String)"Get from Preview", (Object[])new Object[0]));
            this.getMaxButton.setToolTipText(I18n.tr((String)"Select a single node from preview", (Object[])new Object[0]));
            this.getMaxButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlacementPanel.this.setFromCoor(PlacementPanel.this.pdfMax);
                }
            });
            this.hintField = new JLabel(I18n.tr((String)"Check Placement", (Object[])new Object[0]), 0);
            this.hintField.setForeground(Color.RED);
            this.panel = new GuiPanel(new GridBagLayout());
            this.panel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Bind to coordinates", (Object[])new Object[0])));
            GridBagConstraints cBasic = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 2, 21, new Insets(1, 0, 0, 4), 0, 0);
            cBasic.gridx = -1;
            cBasic.gridy = -1;
            cBasic.insets = new Insets(1, 0, 0, 4);
            cBasic.anchor = 21;
            cBasic.fill = 2;
            cBasic.gridheight = 1;
            cBasic.gridwidth = 1;
            cBasic.ipadx = 0;
            cBasic.ipady = 0;
            cBasic.weightx = 0.0;
            cBasic.weighty = 0.0;
            GridBagConstraints cCornerHeading = (GridBagConstraints)cBasic.clone();
            cCornerHeading.gridwidth = 0;
            cCornerHeading.gridx = 0;
            cCornerHeading.insets = new Insets(3, 0, 0, 0);
            GridBagConstraints cLine = (GridBagConstraints)cBasic.clone();
            GridBagConstraints cGetButton = (GridBagConstraints)cBasic.clone();
            cGetButton.gridx = 1;
            cGetButton.gridwidth = 0;
            cGetButton.fill = 0;
            GridBagConstraints c = new GridBagConstraints();
            this.panel.add((Component)this.projectionChooser.getPanel(), cCornerHeading);
            this.panel.add((Component)new JLabel(I18n.tr((String)"Top right (max) corner:", (Object[])new Object[0]), 0), cCornerHeading);
            c = (GridBagConstraints)cLine.clone();
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"X:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.maxXField, c);
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"East:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.maxEastField, c);
            c.gridy = 4;
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"Y:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.maxYField, c);
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"North:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.maxNorthField, c);
            this.panel.add((Component)this.getMaxButton, cGetButton);
            this.panel.add((Component)new JLabel(I18n.tr((String)"Bottom left (min) corner:", (Object[])new Object[0]), 0), cCornerHeading);
            c = (GridBagConstraints)cLine.clone();
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"X:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.minXField, c);
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"East:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.minEastField, c);
            c.gridy = 8;
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"Y:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.minYField, c);
            c.weightx = 0.0;
            this.panel.add((Component)new JLabel(I18n.tr((String)"North:", (Object[])new Object[0]), 4), c);
            c.weightx = 1.0;
            this.panel.add((Component)this.minNorthField, c);
            this.panel.add((Component)this.getMinButton, cGetButton);
            c.gridx = 0;
            c.gridy = 11;
            c.gridwidth = 0;
            c.fill = 2;
            this.panel.add((Component)this.hintField, cGetButton);
        }

        private EastNorth getSelectedCoor() {
            this.hintField.setText("");
            Collection selected = MainApplication.getLayerManager().getEditDataSet().getSelected();
            if (selected.size() != 1 || !(selected.iterator().next() instanceof Node)) {
                this.hintField.setText(I18n.tr((String)"Please select exactly one node.", (Object[])new Object[0]));
                return null;
            }
            LatLon ll = ((Node)selected.iterator().next()).getCoor();
            return new EastNorth(ll.lon() * 1000.0, ll.lat() * 1000.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void Verify() {
            String Hint;
            block6: {
                this.hintField.setText("");
                Hint = "";
                this.fc.valid = false;
                FilePlacement18 placement = this.fc;
                try {
                    placement.projection = this.projectionChooser.getProjection();
                    try {
                        placement.setPdfBounds(this.minXField.getValue(), this.minYField.getValue(), this.maxXField.getValue(), this.maxYField.getValue());
                        placement.setEastNorthBounds(this.minEastField.getValue(), this.minNorthField.getValue(), this.maxEastField.getValue(), this.maxNorthField.getValue());
                    }
                    catch (Exception e) {
                        Hint = I18n.tr((String)"Check numbers", (Object[])new Object[0]);
                        this.hintField.setText(Hint);
                        if (this.dependsOnValid == null) return;
                        this.dependsOnValid.setEnabled(this.fc.valid && this.panel.isEnabled());
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.hintField.setText(Hint);
                    if (this.dependsOnValid == null) throw throwable;
                    this.dependsOnValid.setEnabled(this.fc.valid && this.panel.isEnabled());
                    throw throwable;
                }
                String transformError = placement.prepareTransform();
                if (transformError == null) break block6;
                Hint = transformError;
                this.hintField.setText(Hint);
                if (this.dependsOnValid == null) return;
                this.dependsOnValid.setEnabled(this.fc.valid && this.panel.isEnabled());
                return;
            }
            this.fc.valid = true;
            this.hintField.setText(Hint);
            if (this.dependsOnValid == null) return;
            this.dependsOnValid.setEnabled(this.fc.valid && this.panel.isEnabled());
        }

        public void setDependsOnValid(JComponent c) {
            this.dependsOnValid = c;
        }

        void setFromCoor(CoorFields f) {
            EastNorth en = this.getSelectedCoor();
            if (en != null) {
                f.SetCoor(en);
            }
        }

        private class Monitor
        implements FocusListener {
            private PlacementPanel target = null;

            public Monitor(PlacementPanel home) {
                this.target = home;
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    this.target.Verify();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class CoorFields {
            private GuiFieldDouble x;
            private GuiFieldDouble y;

            private void checkCoords(GuiFieldDouble x, GuiFieldDouble y) {
                int splitpos = 0;
                String val2 = x.getText().trim();
                splitpos = val2.indexOf(59);
                if (splitpos >= 0) {
                    y.setText(val2.substring(splitpos + 1).trim());
                    x.setText(val2.substring(0, splitpos).trim());
                }
                y.checker.check(y);
                x.checker.check(x);
            }

            private CoorFields() {
            }

            CoorFields(final GuiFieldDouble x, final GuiFieldDouble y) {
                this.x = x;
                this.y = y;
                x.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        CoorFields.this.checkCoords(x, y);
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
            }

            public void SetCoor(EastNorth en) {
                this.x.requestFocusInWindow();
                this.x.setValue(en.getX());
                this.y.requestFocusInWindow();
                this.y.setValue(en.getY());
            }

            public EastNorth getCorr() {
                return new EastNorth(this.x.getValue(), this.y.getValue());
            }
        }
    }
}

