/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.geotools.image.ImageWorker;
import org.geotools.util.factory.GeoTools;

class ExtendedRandomIter
implements RandomIter {
    RandomIter delegate;
    RenderedOp op;

    public static RandomIter getRandomIterator(PlanarImage src, int leftPad, int rightPad, int topPad, int bottomPad, BorderExtender extender) {
        if (extender != null) {
            ImageWorker w = new ImageWorker(src).setRenderingHints(GeoTools.getDefaultHints());
            RenderedOp op = w.border(leftPad, rightPad, topPad, bottomPad, extender).getRenderedOperation();
            RandomIter it = RandomIterFactory.create(op, op.getBounds(), true, true);
            return new ExtendedRandomIter(it, op);
        }
        RandomIter iterSource = RandomIterFactory.create(src, src.getBounds(), true, true);
        return iterSource;
    }

    ExtendedRandomIter(RandomIter delegate, RenderedOp op) {
        this.delegate = delegate;
        this.op = op;
    }

    @Override
    public int getSample(int x, int y, int b) {
        return this.delegate.getSample(x, y, b);
    }

    @Override
    public float getSampleFloat(int x, int y, int b) {
        return this.delegate.getSampleFloat(x, y, b);
    }

    @Override
    public double getSampleDouble(int x, int y, int b) {
        return this.delegate.getSampleDouble(x, y, b);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray) {
        return this.delegate.getPixel(x, y, iArray);
    }

    @Override
    public float[] getPixel(int x, int y, float[] fArray) {
        return this.delegate.getPixel(x, y, fArray);
    }

    @Override
    public double[] getPixel(int x, int y, double[] dArray) {
        return this.delegate.getPixel(x, y, dArray);
    }

    @Override
    public void done() {
        this.delegate.done();
        this.op.dispose();
    }
}

