/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.BeamGeography;
import indoor_sweepline.CorridorPart;
import indoor_sweepline.IndoorSweeplineModel;
import java.util.Vector;

public class Beam {
    private double offset;
    private Vector<CorridorPart> parts;
    private Vector<StripPosition> lhsStrips;
    private Vector<StripPosition> rhsStrips;
    private CorridorPart.ReachableSide defaultSide;

    public Beam(Vector<Double> blueprint, double blueprintOffset, CorridorPart.ReachableSide defaultSide) {
        this.offset = blueprintOffset;
        this.parts = new Vector();
        this.setDefaultSide_(defaultSide);
        if (defaultSide == CorridorPart.ReachableSide.RIGHT) {
            for (int i = 1; i < blueprint.size(); i += 2) {
                this.addCorridorPart_(true, CorridorPart.Type.WALL, blueprint.elementAt(i) - blueprint.elementAt(i - 1));
                if (i + 1 >= blueprint.size()) continue;
                this.addCorridorPart_(true, CorridorPart.Type.VOID, blueprint.elementAt(i + 1) - blueprint.elementAt(i));
            }
        } else {
            for (int i = 1; i < blueprint.size(); i += 2) {
                this.addCorridorPart_(true, CorridorPart.Type.PASSAGE, blueprint.elementAt(i) - blueprint.elementAt(i - 1));
                if (i + 1 >= blueprint.size()) continue;
                this.addCorridorPart_(true, CorridorPart.Type.VOID, blueprint.elementAt(i + 1) - blueprint.elementAt(i));
            }
        }
        this.adjustStripCache();
    }

    private void setDefaultSide_(CorridorPart.ReachableSide defaultSide) {
        this.defaultSide = defaultSide;
    }

    public void setDefaultSide(CorridorPart.ReachableSide defaultSide) {
        this.setDefaultSide_(defaultSide);
        this.adjustStripCache();
    }

    public Vector<CorridorPart> getBeamParts() {
        return this.parts;
    }

    public double getBeamOffset() {
        return this.offset;
    }

    public void setBeamOffset(double beamOffset) {
        this.offset = beamOffset;
    }

    private void addCorridorPart_(boolean append, CorridorPart.Type type, double width) {
        CorridorPart.ReachableSide side;
        CorridorPart.ReachableSide reachableSide = side = this.defaultSide == CorridorPart.ReachableSide.RIGHT ? this.defaultSide : CorridorPart.ReachableSide.ALL;
        if (append) {
            this.parts.add(new CorridorPart(width, type, side));
        } else {
            this.parts.add(0, new CorridorPart(width, type, side));
        }
    }

    public void addCorridorPart(boolean append, double width) {
        this.addCorridorPart_(append, this.defaultSide == CorridorPart.ReachableSide.RIGHT ? CorridorPart.Type.WALL : CorridorPart.Type.PASSAGE, width);
        this.adjustStripCache();
    }

    public void setCorridorPartWidth(int partIndex, double value) {
        this.parts.elementAt((int)partIndex).width = value;
        this.adjustStripCache();
    }

    public void setCorridorPartType(int partIndex, CorridorPart.Type type) {
        this.parts.elementAt(partIndex).setType(type, this.defaultSide);
        this.enforceSideCoherence();
        this.adjustStripCache();
    }

    public void setCorridorPartSide(int partIndex, CorridorPart.ReachableSide side) {
        this.parts.elementAt(partIndex).setSide(side, this.defaultSide);
        this.enforceSideCoherence();
        this.adjustStripCache();
    }

    private void enforceSideCoherence() {
        for (int i = 1; i < this.parts.size(); ++i) {
            if (this.parts.elementAt(i).getSide() == CorridorPart.ReachableSide.ALL || this.parts.elementAt(i - 1).getSide() == CorridorPart.ReachableSide.ALL) continue;
            this.parts.elementAt(i).setSide(this.parts.elementAt(i - 1).getSide(), this.defaultSide);
        }
    }

    private boolean isVoidAbove(int i) {
        return i == 0 || this.parts.elementAt(i - 1).getType() == CorridorPart.Type.VOID || this.parts.elementAt(i - 1).getSide() == CorridorPart.ReachableSide.RIGHT && this.defaultSide == CorridorPart.ReachableSide.LEFT || this.parts.elementAt(i - 1).getSide() == CorridorPart.ReachableSide.LEFT && this.defaultSide == CorridorPart.ReachableSide.RIGHT;
    }

    private boolean isVoidBelow(int i) {
        return i == this.parts.size() || this.parts.elementAt(i).getType() == CorridorPart.Type.VOID || this.parts.elementAt(i).getSide() == CorridorPart.ReachableSide.RIGHT && this.defaultSide == CorridorPart.ReachableSide.LEFT || this.parts.elementAt(i).getSide() == CorridorPart.ReachableSide.LEFT && this.defaultSide == CorridorPart.ReachableSide.RIGHT;
    }

    private boolean isPassageAbove(int i) {
        return i > 0 && this.parts.elementAt(i - 1).getType() == CorridorPart.Type.PASSAGE && this.defaultSide == CorridorPart.ReachableSide.ALL;
    }

    private boolean isPassageBelow(int i) {
        return i < this.parts.size() && this.parts.elementAt(i).getType() == CorridorPart.Type.PASSAGE && this.defaultSide == CorridorPart.ReachableSide.ALL;
    }

    private boolean isReachableLeft(int i) {
        if (this.defaultSide == CorridorPart.ReachableSide.RIGHT) {
            return false;
        }
        if (this.parts.elementAt(i).getSide() == CorridorPart.ReachableSide.LEFT) {
            return true;
        }
        return this.defaultSide == CorridorPart.ReachableSide.LEFT;
    }

    private void connectTwoPos(StripPosition newPos, boolean toLeft) {
        StripPosition other = null;
        if (this.rhsStrips.size() > 0 && this.rhsStrips.elementAt((int)(this.rhsStrips.size() - 1)).connectedTo == -1) {
            newPos.connectedToSameSide = !toLeft;
            newPos.connectedTo = this.rhsStrips.size() - 1;
            other = this.rhsStrips.elementAt(this.rhsStrips.size() - 1);
        } else {
            newPos.connectedToSameSide = toLeft;
            newPos.connectedTo = this.lhsStrips.size() - 1;
            other = this.lhsStrips.elementAt(this.lhsStrips.size() - 1);
        }
        other.connectedToSameSide = newPos.connectedToSameSide;
        if (toLeft) {
            other.connectedTo = this.lhsStrips.size();
            this.lhsStrips.add(newPos);
        } else {
            other.connectedTo = this.rhsStrips.size();
            this.rhsStrips.add(newPos);
        }
    }

    private void adjustStripCache() {
        this.lhsStrips = new Vector();
        this.rhsStrips = new Vector();
        double offset = 0.0;
        for (int i = 0; i <= this.parts.size(); ++i) {
            StripPosition rhs;
            StripPosition lhs;
            if (this.isVoidBelow(i)) {
                if (this.isPassageAbove(i)) {
                    lhs = new StripPosition(i, offset);
                    rhs = new StripPosition(i, offset);
                    lhs.connectedToSameSide = false;
                    lhs.connectedTo = this.rhsStrips.size();
                    rhs.connectedToSameSide = false;
                    rhs.connectedTo = this.lhsStrips.size();
                    this.lhsStrips.add(lhs);
                    this.rhsStrips.add(rhs);
                } else if (!this.isVoidAbove(i)) {
                    this.connectTwoPos(new StripPosition(i, offset), this.isReachableLeft(i - 1));
                }
            } else if (this.isPassageBelow(i)) {
                if (this.isVoidAbove(i)) {
                    lhs = new StripPosition(i, offset);
                    rhs = new StripPosition(i, offset);
                    lhs.connectedToSameSide = false;
                    lhs.connectedTo = this.rhsStrips.size();
                    rhs.connectedToSameSide = false;
                    rhs.connectedTo = this.lhsStrips.size();
                    this.lhsStrips.add(lhs);
                    this.rhsStrips.add(rhs);
                } else if (!this.isPassageAbove(i)) {
                    this.connectTwoPos(new StripPosition(i, offset), !this.isReachableLeft(i - 1));
                }
            } else if (this.isVoidAbove(i)) {
                if (this.isReachableLeft(i)) {
                    this.lhsStrips.add(new StripPosition(i, offset));
                } else {
                    this.rhsStrips.add(new StripPosition(i, offset));
                }
            } else if (this.isPassageAbove(i)) {
                if (this.isReachableLeft(i)) {
                    this.rhsStrips.add(new StripPosition(i, offset));
                } else {
                    this.lhsStrips.add(new StripPosition(i, offset));
                }
            }
            if (i >= this.parts.size()) continue;
            offset += this.parts.elementAt((int)i).width;
        }
    }

    public Vector<Double> leftHandSideStrips() {
        Vector<Double> offsets = new Vector<Double>();
        for (StripPosition pos : this.lhsStrips) {
            offsets.add(pos.offset);
        }
        return offsets;
    }

    public Vector<Double> rightHandSideStrips() {
        Vector<Double> offsets = new Vector<Double>();
        for (StripPosition pos : this.rhsStrips) {
            offsets.add(pos.offset);
        }
        return offsets;
    }

    public int getBeamPartIndex(boolean toTheLeft, int i) {
        if (toTheLeft) {
            return this.lhsStrips.elementAt((int)i).nodeIndex;
        }
        return this.rhsStrips.elementAt((int)i).nodeIndex;
    }

    public boolean appendNodes(IndoorSweeplineModel.SweepPolygonCursor cursor, boolean fromRight, BeamGeography geography, String level) {
        if (fromRight) {
            StripPosition pos = this.rhsStrips.elementAt(cursor.partIndex);
            StripPosition to = pos.connectedToSameSide ? this.rhsStrips.elementAt(pos.connectedTo) : this.lhsStrips.elementAt(pos.connectedTo);
            geography.appendNodes(pos.nodeIndex, to.nodeIndex, level);
            if (!pos.connectedToSameSide) {
                --cursor.stripIndex;
            }
            cursor.partIndex = pos.connectedTo;
            return !pos.connectedToSameSide;
        }
        StripPosition pos = this.lhsStrips.elementAt(cursor.partIndex);
        StripPosition to = pos.connectedToSameSide ? this.lhsStrips.elementAt(pos.connectedTo) : this.rhsStrips.elementAt(pos.connectedTo);
        geography.appendNodes(pos.nodeIndex, to.nodeIndex, level);
        if (!pos.connectedToSameSide) {
            ++cursor.stripIndex;
        }
        cursor.partIndex = pos.connectedTo;
        return pos.connectedToSameSide;
    }

    private static class StripPosition {
        public int nodeIndex;
        public double offset;
        public int connectedTo;
        public boolean connectedToSameSide;

        StripPosition(int nodeIndex, double offset) {
            this.nodeIndex = nodeIndex;
            this.offset = offset;
            this.connectedTo = -1;
            this.connectedToSameSide = false;
        }
    }
}

