/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher.function;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunction;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;

public final class MD5Cyclic
implements HashFunction {
    private final MessageDigest messageDigest;
    private final long signature;
    private final long[] result = new long[2];
    public static final String NAME = "MD5";

    public MD5Cyclic() {
        try {
            this.messageDigest = MessageDigest.getInstance(NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.signature = this.apply(HashFunctionIdentity.prepareSignatureBuffer(this), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long apply(byte[] buffer, int seed) {
        if (seed == 0) {
            byte[] hash;
            MessageDigest messageDigest = this.messageDigest;
            synchronized (messageDigest) {
                this.messageDigest.update(buffer);
                hash = this.messageDigest.digest();
                this.messageDigest.reset();
            }
            LongBuffer lb = ByteBuffer.wrap(hash).asLongBuffer();
            this.result[0] = lb.get(0);
            this.result[1] = lb.get(1);
        } else {
            this.result[0] = this.result[0] + this.result[1];
        }
        return this.result[0];
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getProvider() {
        return "Apache Commons Collections";
    }

    @Override
    public HashFunctionIdentity.Signedness getSignedness() {
        return HashFunctionIdentity.Signedness.SIGNED;
    }

    @Override
    public HashFunctionIdentity.ProcessType getProcessType() {
        return HashFunctionIdentity.ProcessType.CYCLIC;
    }

    @Override
    public long getSignature() {
        return this.signature;
    }
}

