/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.TreeSet;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;

public final class StaticHasher
implements Hasher {
    private final Shape shape;
    private final int[] values;

    public StaticHasher(StaticHasher hasher, Shape shape) {
        if (!hasher.shape.equals(shape)) {
            throw new IllegalArgumentException(String.format("Hasher shape (%s) is not the same as shape (%s)", hasher.getShape().toString(), shape.toString()));
        }
        this.shape = shape;
        this.values = hasher.values;
    }

    public StaticHasher(Hasher hasher, Shape shape) {
        this(hasher.getBits(shape), shape);
        if (HashFunctionIdentity.COMMON_COMPARATOR.compare(hasher.getHashFunctionIdentity(), shape.getHashFunctionIdentity()) != 0) {
            throw new IllegalArgumentException(String.format("Hasher (%s) is not the same as for shape (%s)", HashFunctionIdentity.asCommonString(hasher.getHashFunctionIdentity()), shape.toString()));
        }
    }

    public StaticHasher(Iterator<Integer> iter, Shape shape) {
        this.shape = shape;
        TreeSet workingValues = new TreeSet();
        iter.forEachRemaining(idx -> {
            if (idx >= this.shape.getNumberOfBits()) {
                throw new IllegalArgumentException(String.format("Bit index (%s) is too big for %s", idx, shape));
            }
            if (idx < 0) {
                throw new IllegalArgumentException(String.format("Bit index (%s) may not be less than zero", idx));
            }
            workingValues.add(idx);
        });
        this.values = new int[workingValues.size()];
        int i = 0;
        for (Integer value : workingValues) {
            this.values[i++] = value;
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public HashFunctionIdentity getHashFunctionIdentity() {
        return this.shape.getHashFunctionIdentity();
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public PrimitiveIterator.OfInt getBits(Shape shape) {
        if (!this.shape.equals(shape)) {
            throw new IllegalArgumentException(String.format("shape (%s) does not match internal shape (%s)", shape, this.shape));
        }
        return Arrays.stream(this.values).iterator();
    }
}

