/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.AbstractMap;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;
import org.apache.commons.collections4.bloomfilter.hasher.StaticHasher;

public class CountingBloomFilter
extends AbstractBloomFilter {
    private final TreeMap<Integer, Integer> counts;

    public CountingBloomFilter(Hasher hasher, Shape shape) {
        super(shape);
        this.verifyHasher(hasher);
        this.counts = new TreeMap();
        HashSet idxs = new HashSet();
        hasher.getBits(shape).forEachRemaining(idxs::add);
        idxs.stream().forEach(idx -> this.counts.put((Integer)idx, 1));
    }

    public CountingBloomFilter(Shape shape) {
        super(shape);
        this.counts = new TreeMap();
    }

    public CountingBloomFilter(Map<Integer, Integer> counts, Shape shape) {
        this(shape);
        counts.entrySet().stream().forEach(e -> {
            if ((Integer)e.getKey() >= shape.getNumberOfBits()) {
                throw new IllegalArgumentException("dataMap has an item with an index larger than " + (shape.getNumberOfBits() - 1));
            }
            if ((Integer)e.getKey() < 0) {
                throw new IllegalArgumentException("dataMap has an item with an index less than 0");
            }
            if ((Integer)e.getValue() < 0) {
                throw new IllegalArgumentException("dataMap has an item with an value less than 0");
            }
            if ((Integer)e.getValue() > 0) {
                this.counts.put((Integer)e.getKey(), (Integer)e.getValue());
            }
        });
    }

    public Stream<Map.Entry<Integer, Integer>> getCounts() {
        return this.counts.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ ");
        for (Map.Entry<Integer, Integer> e : this.counts.entrySet()) {
            sb.append(String.format("(%s,%s) ", e.getKey(), e.getValue()));
        }
        return sb.append("}").toString();
    }

    @Override
    public void merge(BloomFilter other) {
        this.verifyShape(other);
        if (other instanceof CountingBloomFilter) {
            this.merge(((CountingBloomFilter)other).counts.keySet().iterator());
        } else {
            this.merge(BitSet.valueOf(other.getBits()).stream().iterator());
        }
    }

    @Override
    public void merge(Hasher hasher) {
        this.verifyHasher(hasher);
        this.merge(hasher.getBits(this.getShape()));
    }

    private void merge(Iterator<Integer> iter) {
        iter.forEachRemaining(idx -> {
            Integer val = this.counts.get(idx);
            if (val == null) {
                this.counts.put((Integer)idx, 1);
            } else {
                if (val == Integer.MAX_VALUE) {
                    throw new IllegalStateException("Overflow on index " + idx);
                }
                this.counts.put((Integer)idx, val + 1);
            }
        });
    }

    public void remove(BloomFilter other) {
        this.verifyShape(other);
        if (other instanceof CountingBloomFilter) {
            this.remove(((CountingBloomFilter)other).counts.keySet().stream());
        } else {
            this.remove(BitSet.valueOf(other.getBits()).stream().boxed());
        }
    }

    public void remove(Hasher hasher) {
        this.verifyHasher(hasher);
        HashSet lst = new HashSet();
        hasher.getBits(this.getShape()).forEachRemaining((Consumer<? super Integer>)((Consumer<Integer>)lst::add));
        this.remove(lst.stream());
    }

    private void remove(Stream<Integer> idxStream) {
        idxStream.forEach(idx -> {
            Integer val = this.counts.get(idx);
            if (val != null) {
                if (val - 1 == 0) {
                    this.counts.remove(idx);
                } else {
                    this.counts.put((Integer)idx, val - 1);
                }
            }
            if (val == null || val == 0) {
                throw new IllegalStateException("Underflow on index " + idx);
            }
            if (val - 1 == 0) {
                this.counts.remove(idx);
            } else {
                this.counts.put((Integer)idx, val - 1);
            }
        });
    }

    @Override
    public long[] getBits() {
        BitSet bs = new BitSet();
        this.counts.keySet().stream().forEach(bs::set);
        return bs.toLongArray();
    }

    @Override
    public StaticHasher getHasher() {
        return new StaticHasher(this.counts.keySet().iterator(), this.getShape());
    }

    @Override
    public boolean contains(Hasher hasher) {
        this.verifyHasher(hasher);
        PrimitiveIterator.OfInt iter = hasher.getBits(this.getShape());
        while (iter.hasNext()) {
            if (this.counts.get(iter.nextInt()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int cardinality() {
        return this.counts.size();
    }

    @Override
    public int andCardinality(BloomFilter other) {
        if (other instanceof CountingBloomFilter) {
            HashSet<Integer> result = new HashSet<Integer>(this.counts.keySet());
            result.retainAll(((CountingBloomFilter)other).counts.keySet());
            return result.size();
        }
        return super.andCardinality(other);
    }
}

