/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.BitSet;
import java.util.PrimitiveIterator;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;
import org.apache.commons.collections4.bloomfilter.hasher.StaticHasher;

public class BitSetBloomFilter
extends AbstractBloomFilter {
    private final BitSet bitSet = new BitSet();

    public BitSetBloomFilter(Hasher hasher, Shape shape) {
        this(shape);
        this.verifyHasher(hasher);
        hasher.getBits(shape).forEachRemaining(this.bitSet::set);
    }

    public BitSetBloomFilter(Shape shape) {
        super(shape);
    }

    @Override
    public long[] getBits() {
        return this.bitSet.toLongArray();
    }

    @Override
    public StaticHasher getHasher() {
        return new StaticHasher(this.bitSet.stream().iterator(), this.getShape());
    }

    @Override
    public void merge(BloomFilter other) {
        this.verifyShape(other);
        if (other instanceof BitSetBloomFilter) {
            this.bitSet.or(((BitSetBloomFilter)other).bitSet);
        } else {
            this.bitSet.or(BitSet.valueOf(other.getBits()));
        }
    }

    @Override
    public boolean contains(Hasher hasher) {
        this.verifyHasher(hasher);
        PrimitiveIterator.OfInt iter = hasher.getBits(this.getShape());
        while (iter.hasNext()) {
            if (this.bitSet.get(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int cardinality() {
        return this.bitSet.cardinality();
    }

    public String toString() {
        return this.bitSet.toString();
    }

    @Override
    public void merge(Hasher hasher) {
        this.verifyHasher(hasher);
        hasher.getBits(this.getShape()).forEachRemaining(this.bitSet::set);
    }

    @Override
    public int andCardinality(BloomFilter other) {
        if (other instanceof BitSetBloomFilter) {
            this.verifyShape(other);
            BitSet result = (BitSet)this.bitSet.clone();
            result.and(((BitSetBloomFilter)other).bitSet);
            return result.cardinality();
        }
        return super.andCardinality(other);
    }

    @Override
    public int xorCardinality(BloomFilter other) {
        if (other instanceof BitSetBloomFilter) {
            this.verifyShape(other);
            BitSet result = (BitSet)this.bitSet.clone();
            result.xor(((BitSetBloomFilter)other).bitSet);
            return result.cardinality();
        }
        return super.xorCardinality(other);
    }
}

