/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.BitSet;
import java.util.PrimitiveIterator;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;
import org.apache.commons.collections4.bloomfilter.hasher.StaticHasher;

public abstract class AbstractBloomFilter
implements BloomFilter {
    private final Shape shape;

    @Override
    public abstract long[] getBits();

    @Override
    public abstract StaticHasher getHasher();

    protected AbstractBloomFilter(Shape shape) {
        this.shape = shape;
    }

    protected void verifyShape(BloomFilter other) {
        this.verifyShape(other.getShape());
    }

    protected void verifyShape(Shape shape) {
        if (!this.shape.equals(shape)) {
            throw new IllegalArgumentException(String.format("Shape %s is not the same as %s", shape, this.shape));
        }
    }

    protected void verifyHasher(Hasher hasher) {
        if (this.shape.getHashFunctionIdentity().getSignature() != hasher.getHashFunctionIdentity().getSignature()) {
            throw new IllegalArgumentException(String.format("Hasher (%s) is not the hasher for shape (%s)", HashFunctionIdentity.asCommonString(hasher.getHashFunctionIdentity()), this.shape.toString()));
        }
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public abstract void merge(BloomFilter var1);

    @Override
    public abstract void merge(Hasher var1);

    @Override
    public int cardinality() {
        return BitSet.valueOf(this.getBits()).cardinality();
    }

    @Override
    public int andCardinality(BloomFilter other) {
        this.verifyShape(other);
        long[] mine = this.getBits();
        long[] theirs = other.getBits();
        int limit = Integer.min(mine.length, theirs.length);
        long[] result = new long[limit];
        for (int i = 0; i < limit; ++i) {
            result[i] = mine[i] & theirs[i];
        }
        return BitSet.valueOf(result).cardinality();
    }

    @Override
    public int orCardinality(BloomFilter other) {
        this.verifyShape(other);
        long[] mine = this.getBits();
        long[] theirs = other.getBits();
        long[] remainder = null;
        long[] result = null;
        if (mine.length > theirs.length) {
            result = new long[mine.length];
            remainder = mine;
        } else {
            result = new long[theirs.length];
            remainder = theirs;
        }
        int limit = Integer.min(mine.length, theirs.length);
        for (int i = 0; i < limit; ++i) {
            result[i] = mine[i] | theirs[i];
        }
        if (limit < result.length) {
            System.arraycopy(remainder, limit, result, limit, result.length - limit);
        }
        return BitSet.valueOf(result).cardinality();
    }

    @Override
    public int xorCardinality(BloomFilter other) {
        this.verifyShape(other);
        long[] mine = this.getBits();
        long[] theirs = other.getBits();
        long[] remainder = null;
        long[] result = null;
        if (mine.length > theirs.length) {
            result = new long[mine.length];
            remainder = mine;
        } else {
            result = new long[theirs.length];
            remainder = theirs;
        }
        int limit = Integer.min(mine.length, theirs.length);
        for (int i = 0; i < limit; ++i) {
            result[i] = mine[i] ^ theirs[i];
        }
        if (limit < result.length) {
            System.arraycopy(remainder, limit, result, limit, result.length - limit);
        }
        return BitSet.valueOf(result).cardinality();
    }

    @Override
    public boolean contains(BloomFilter other) {
        this.verifyShape(other);
        return other.cardinality() == this.andCardinality(other);
    }

    @Override
    public boolean contains(Hasher hasher) {
        this.verifyHasher(hasher);
        long[] buff = this.getBits();
        PrimitiveIterator.OfInt iter = hasher.getBits(this.shape);
        while (iter.hasNext()) {
            int pwr;
            long buffOffset;
            int idx = iter.nextInt();
            int buffIdx = idx / 64;
            if ((buff[buffIdx] & (buffOffset = 1L << (pwr = Math.floorMod(idx, 64)))) != 0L) continue;
            return false;
        }
        return true;
    }

    public final boolean isFull() {
        return this.cardinality() == this.getShape().getNumberOfBits();
    }
}

