/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.indoorhelper;

import controller.IndoorHelperController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;

public class IndoorHelperPlugin
extends Plugin
implements MapViewPaintable.PaintableInvalidationListener,
MainLayerManager.ActiveLayerChangeListener {
    private IndoorHelperController controller;
    String sep = System.getProperty("file.separator");

    public IndoorHelperPlugin(PluginInformation info) throws IOException {
        super(info);
        this.exportStyleFile("sit.mapcss");
        this.exportStyleFile("entrance_door_icon.png");
        this.exportStyleFile("entrance_icon.png");
        this.exportStyleFile("elevator_icon.png");
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (oldFrame == null && newFrame != null) {
            this.controller = new IndoorHelperController();
        }
    }

    private void exportStyleFile(String resourceName) throws IOException {
        try (InputStream stream = IndoorHelperPlugin.class.getResourceAsStream("/data/" + resourceName);){
            if (stream == null) {
                throw new IOException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            String valDirPath = Config.getDirs().getUserDataDirectory(true) + this.sep + "styles";
            File valDir = new File(valDirPath);
            valDir.mkdirs();
            String outPath = valDir.getAbsolutePath() + this.sep + resourceName;
            try (FileOutputStream resStreamOut = new FileOutputStream(outPath);){
                int readBytes;
                while ((readBytes = stream.read(buffer)) > 0) {
                    ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
                }
            }
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            editLayer.addInvalidationListener((MapViewPaintable.PaintableInvalidationListener)this);
        }
    }

    public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent event) {
        AutoFilter currentAutoFilter = AutoFilterManager.getInstance().getCurrentAutoFilter();
        if (currentAutoFilter != null) {
            if (this.controller != null) {
                String currentFilterValue = currentAutoFilter.getFilter().text.split("=")[1];
                this.controller.setIndoorLevel(currentFilterValue);
                this.controller.getIndoorLevel(currentFilterValue);
                this.controller.unsetSpecificKeyFilter("repeat_on");
            }
        } else if (this.controller != null) {
            this.controller.setIndoorLevel("");
            this.controller.getIndoorLevel("");
        }
    }
}

