/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParseException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ReadRemoteModuleInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<ModuleInformation> availableModules;

    protected void init(Collection<String> sites) {
        this.sites = sites;
        if (sites == null) {
            this.sites = Collections.emptySet();
        }
        this.availableModules = new LinkedList<ModuleInformation>();
    }

    public ReadRemoteModuleInformationTask(Collection<String> sites) {
        super(I18n.tr((String)"Download module list...", (Object[])new Object[0]), false);
        this.init(sites);
    }

    public ReadRemoteModuleInformationTask(ProgressMonitor monitor, Collection<String> sites) {
        super(I18n.tr((String)"Download module list...", (Object[])new Object[0]), monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        this.init(sites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        ReadRemoteModuleInformationTask readRemoteModuleInformationTask = this;
        synchronized (readRemoteModuleInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    protected void finish() {
    }

    protected File createSiteCacheFile(File moduleDir, String site, CacheType type) {
        String name;
        try {
            site = site.replaceAll("%<(.*)>", "");
            URL url = new URL(site);
            StringBuilder sb = new StringBuilder();
            sb.append("site-");
            sb.append(url.getHost()).append("-");
            if (url.getPort() != -1) {
                sb.append(url.getPort()).append("-");
            }
            String path = url.getPath();
            for (int i = 0; i < path.length() - 4; ++i) {
                char c = path.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append("_");
            }
            switch (type) {
                case PLUGIN_LIST: {
                    sb.append(".txt");
                    break;
                }
                case ICON_LIST: {
                    sb.append("-icons.zip");
                }
            }
            name = sb.toString();
        }
        catch (MalformedURLException e) {
            name = "site-unknown.txt";
        }
        return new File(moduleDir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadModuleList(String site, ProgressMonitor monitor) {
        ReadRemoteModuleInformationTask readRemoteModuleInformationTask;
        StringBuilder sb = new StringBuilder();
        try {
            String string;
            String printsite = site.replaceAll("%<(.*)>", "");
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading module list from ''{0}''", (Object[])new Object[]{printsite}));
            URL url = new URL(printsite);
            readRemoteModuleInformationTask = this;
            synchronized (readRemoteModuleInformationTask) {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", url.getHost());
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            Throwable throwable = null;
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                string = sb.toString();
            }
            catch (Throwable throwable2) {
                String string2;
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ReadRemoteModuleInformationTask.$closeResource(throwable, in);
                        throw throwable3;
                    }
                }
                catch (MalformedURLException e) {
                    if (this.canceled) {
                        string2 = null;
                        return string2;
                    }
                    e.printStackTrace();
                    string2 = null;
                    return string2;
                }
                catch (IOException e) {
                    if (this.canceled) {
                        string2 = null;
                        return string2;
                    }
                    e.printStackTrace();
                    string2 = null;
                    return string2;
                }
            }
            ReadRemoteModuleInformationTask.$closeResource(throwable, in);
            return string;
        }
        finally {
            readRemoteModuleInformationTask = this;
            synchronized (readRemoteModuleInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            monitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadModuleIcons(String site, File destFile, ProgressMonitor monitor) {
        try {
            site = site.replaceAll("%<(.*)>", "");
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading module list from ''{0}''", (Object[])new Object[]{site}));
            Object url = new URL(site);
            ReadRemoteModuleInformationTask readRemoteModuleInformationTask = this;
            synchronized (readRemoteModuleInformationTask) {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", url.getHost());
            }
            try (InputStream in = this.connection.getInputStream();
                 FileOutputStream out = new FileOutputStream(destFile);){
                byte[] buffer = new byte[8192];
                int read = in.read(buffer);
                while (read != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                    read = in.read(buffer);
                }
            }
        }
        catch (MalformedURLException e) {
            if (this.canceled) {
                return;
            }
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            e.printStackTrace();
            return;
        }
        finally {
            ReadRemoteModuleInformationTask in = this;
            synchronized (in) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            monitor.finishTask();
        }
        for (ModuleInformation pi : this.availableModules) {
            if (pi.icon != null || pi.iconPath == null) continue;
            pi.icon = new ImageProvider(pi.name + ".jar/" + pi.iconPath).setArchive(destFile).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
        }
    }

    protected void cacheModuleList(String site, String list) {
        try {
            File moduleDir = OdPlugin.getInstance().getModulesDirectory();
            if (!moduleDir.exists() && !moduleDir.mkdirs()) {
                Logging.warn((String)I18n.tr((String)"Warning: failed to create module directory ''{0}''. Cannot cache module list from module site ''{1}''.", (Object[])new Object[]{moduleDir.toString(), site}));
            }
            File cacheFile = this.createSiteCacheFile(moduleDir, site, CacheType.PLUGIN_LIST);
            this.getProgressMonitor().subTask(I18n.tr((String)"Writing module list to local cache ''{0}''", (Object[])new Object[]{cacheFile.toString()}));
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "utf-8"));){
                writer.write(list);
            }
        }
        catch (IOException e) {
            Logging.warn((Throwable)e);
        }
    }

    protected void parseModuleListDocument(String site, String doc) {
        try {
            this.getProgressMonitor().subTask(I18n.tr((String)"Parsing module list from site ''{0}''", (Object[])new Object[]{site}));
            ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes("UTF-8"));
            this.availableModules.addAll(new ModuleListParser().parse(in));
        }
        catch (UnsupportedEncodingException e) {
            Logging.error((String)I18n.tr((String)"Failed to parse module list document from site ''{0}''. Skipping site. Exception was: {1}", (Object[])new Object[]{site, e.toString()}));
            e.printStackTrace();
        }
        catch (ModuleListParseException e) {
            Logging.error((String)I18n.tr((String)"Failed to parse module list document from site ''{0}''. Skipping site. Exception was: {1}", (Object[])new Object[]{site, e.toString()}));
            e.printStackTrace();
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        LinkedList<File> siteCacheFiles = new LinkedList<File>();
        for (String location : ModuleInformation.getModuleLocations()) {
            File[] f = new File(location).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("^([0-9]+-)?site.*\\.txt$") || name.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (f == null || f.length <= 0) continue;
            siteCacheFiles.addAll(Arrays.asList(f));
        }
        for (String site : this.sites) {
            String printsite = site.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr((String)"Processing module list from site ''{0}''", (Object[])new Object[]{printsite}));
            String list = this.downloadModuleList(site, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            siteCacheFiles.remove(this.createSiteCacheFile(moduleDir, site, CacheType.PLUGIN_LIST));
            siteCacheFiles.remove(this.createSiteCacheFile(moduleDir, site, CacheType.ICON_LIST));
            if (list != null) {
                this.getProgressMonitor().worked(1);
                this.cacheModuleList(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                this.parseModuleListDocument(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
            }
            this.downloadModuleIcons(site.replace(".txt", "") + "-icons.zip", this.createSiteCacheFile(moduleDir, site, CacheType.ICON_LIST), this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        for (File file : siteCacheFiles) {
            file.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<ModuleInformation> getAvailableModules() {
        return this.availableModules;
    }

    protected static enum CacheType {
        PLUGIN_LIST,
        ICON_LIST;

    }
}

