/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.culture;

import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class MuseeHandler
extends ToulouseDataSetHandler {
    public MuseeHandler() {
        super("musees", "tourism=museum");
        this.setWikiPage("Mus\u00e9es");
        this.setCategory(CAT_CULTURE);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvKmzTabFilename(filename, new String[]{"Musee"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            this.replace((IPrimitive)n, "NOMS", "name");
            this.replace((IPrimitive)n, "SITE_INTERNET", "contact:website");
            n.put("tourism", "museum");
            n.remove("ADRESSES");
            n.remove("Num");
            n.remove("Index");
            this.replacePhone((OsmPrimitive)n, "TELEPHONE");
            String name = WordUtils.capitalizeFully((String)n.get("name")).replace("Musee", "Mus\u00e9e").replace(" D ", " d'").replace(" L ", " l'").trim();
            int index = name.indexOf("Mus\u00e9e");
            if (index > 1) {
                name = name.substring(index) + " " + name.substring(0, index - 1);
            }
            while (name.contains("  ")) {
                name = name.replace("  ", " ");
            }
            n.put("name", name);
        }
    }
}

