/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.citoyennete;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class BureauxVoteHandler
extends ToulouseDataSetHandler {
    public BureauxVoteHandler() {
        super("elections-2017-lieux-de-vote", "polling_station");
        this.setWikiPage("Elections 2017 - Lieux de vote");
        this.setCategory(CAT_CITOYENNETE);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsKmzTabFilename(filename, new String[]{"Lieu_vote_2012"});
    }

    public void updateDataSet(DataSet ds) {
        for (Relation r : ds.getRelations()) {
            this.replace((IPrimitive)r, "TEXT", "name");
            r.put("polling_station", "2017");
            r.put("building", "yes");
            String name = r.getName();
            if (name == null) continue;
            if (name.contains("ECOLE") || name.contains("MATERNELLE")) {
                r.put("amenity", "school");
                continue;
            }
            if (name.contains("MAIRIE")) {
                r.put("amenity", "townhall");
                continue;
            }
            if (!name.contains("PISCINE")) continue;
            r.put("leisure", "swimming_pool");
        }
    }
}

