/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class GroupMarkerSubRecord
extends SubRecord {
    public static final short sid = 6;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] reserved;

    public GroupMarkerSubRecord() {
        this.reserved = EMPTY_BYTE_ARRAY;
    }

    public GroupMarkerSubRecord(LittleEndianInput littleEndianInput, int n) {
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        this.reserved = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("[ftGmo]" + string);
        stringBuffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(string);
        stringBuffer.append("[/ftGmo]" + string);
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(6);
        littleEndianOutput.writeShort(this.reserved.length);
        littleEndianOutput.write(this.reserved);
    }

    @Override
    protected int getDataSize() {
        return this.reserved.length;
    }

    public short getSid() {
        return 6;
    }

    @Override
    public Object clone() {
        GroupMarkerSubRecord groupMarkerSubRecord = new GroupMarkerSubRecord();
        groupMarkerSubRecord.reserved = new byte[this.reserved.length];
        for (int i = 0; i < this.reserved.length; ++i) {
            groupMarkerSubRecord.reserved[i] = this.reserved[i];
        }
        return groupMarkerSubRecord;
    }
}

