/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.util.CellRangeAddress;

public final class FormulaRecordAggregate
extends RecordAggregate
implements CellValueRecordInterface {
    private final FormulaRecord _formulaRecord;
    private SharedValueManager _sharedValueManager;
    private StringRecord _stringRecord;
    private SharedFormulaRecord _sharedFormulaRecord;

    public FormulaRecordAggregate(FormulaRecord formulaRecord, StringRecord stringRecord, SharedValueManager sharedValueManager) {
        if (sharedValueManager == null) {
            throw new IllegalArgumentException("sfm must not be null");
        }
        if (formulaRecord.hasCachedResultString()) {
            if (stringRecord == null) {
                throw new RecordFormatException("Formula record flag is set but String record was not found");
            }
            this._stringRecord = stringRecord;
        } else {
            this._stringRecord = null;
        }
        this._formulaRecord = formulaRecord;
        this._sharedValueManager = sharedValueManager;
        if (formulaRecord.isSharedFormula()) {
            CellReference cellReference = formulaRecord.getFormula().getExpReference();
            if (cellReference == null) {
                FormulaRecordAggregate.handleMissingSharedFormulaRecord(formulaRecord);
            } else {
                this._sharedFormulaRecord = sharedValueManager.linkSharedFormulaRecord(cellReference, this);
            }
        }
    }

    private static void handleMissingSharedFormulaRecord(FormulaRecord formulaRecord) {
        Ptg ptg = formulaRecord.getParsedExpression()[0];
        if (ptg instanceof ExpPtg) {
            throw new RecordFormatException("SharedFormulaRecord not found for FormulaRecord with (isSharedFormula=true)");
        }
        formulaRecord.setSharedFormula(false);
    }

    public FormulaRecord getFormulaRecord() {
        return this._formulaRecord;
    }

    @Override
    public short getXFIndex() {
        return this._formulaRecord.getXFIndex();
    }

    @Override
    public void setXFIndex(short s) {
        this._formulaRecord.setXFIndex(s);
    }

    @Override
    public void setColumn(short s) {
        this._formulaRecord.setColumn(s);
    }

    @Override
    public void setRow(int n) {
        this._formulaRecord.setRow(n);
    }

    @Override
    public short getColumn() {
        return this._formulaRecord.getColumn();
    }

    @Override
    public int getRow() {
        return this._formulaRecord.getRow();
    }

    public String toString() {
        return this._formulaRecord.toString();
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        recordVisitor.visitRecord(this._formulaRecord);
        SharedValueRecordBase sharedValueRecordBase = this._sharedValueManager.getRecordForFirstCell(this);
        if (sharedValueRecordBase != null) {
            recordVisitor.visitRecord(sharedValueRecordBase);
        }
        if (this._formulaRecord.hasCachedResultString() && this._stringRecord != null) {
            recordVisitor.visitRecord(this._stringRecord);
        }
    }

    public String getStringValue() {
        if (this._stringRecord == null) {
            return null;
        }
        return this._stringRecord.getString();
    }

    public Ptg[] getFormulaTokens() {
        if (this._sharedFormulaRecord != null) {
            return this._sharedFormulaRecord.getFormulaTokens(this._formulaRecord);
        }
        CellReference cellReference = this._formulaRecord.getFormula().getExpReference();
        if (cellReference != null) {
            ArrayRecord arrayRecord = this._sharedValueManager.getArrayRecord(cellReference.getRow(), cellReference.getCol());
            return arrayRecord.getFormulaTokens();
        }
        return this._formulaRecord.getParsedExpression();
    }

    public void unlinkSharedFormula() {
        SharedFormulaRecord sharedFormulaRecord = this._sharedFormulaRecord;
        if (sharedFormulaRecord == null) {
            throw new IllegalStateException("Formula not linked to shared formula");
        }
        Ptg[] ptgArray = sharedFormulaRecord.getFormulaTokens(this._formulaRecord);
        this._formulaRecord.setParsedExpression(ptgArray);
        this._formulaRecord.setSharedFormula(false);
        this._sharedFormulaRecord = null;
    }

    public void notifyFormulaChanging() {
        if (this._sharedFormulaRecord != null) {
            this._sharedValueManager.unlink(this._sharedFormulaRecord);
        }
    }

    public boolean isPartOfArrayFormula() {
        if (this._sharedFormulaRecord != null) {
            return false;
        }
        CellReference cellReference = this._formulaRecord.getFormula().getExpReference();
        ArrayRecord arrayRecord = cellReference == null ? null : this._sharedValueManager.getArrayRecord(cellReference.getRow(), cellReference.getCol());
        return arrayRecord != null;
    }

    public CellRangeAddress getArrayFormulaRange() {
        if (this._sharedFormulaRecord != null) {
            throw new IllegalStateException("not an array formula cell.");
        }
        CellReference cellReference = this._formulaRecord.getFormula().getExpReference();
        if (cellReference == null) {
            throw new IllegalStateException("not an array formula cell.");
        }
        ArrayRecord arrayRecord = this._sharedValueManager.getArrayRecord(cellReference.getRow(), cellReference.getCol());
        if (arrayRecord == null) {
            throw new IllegalStateException("ArrayRecord was not found for the locator " + cellReference.formatAsString());
        }
        CellRangeAddress8Bit cellRangeAddress8Bit = arrayRecord.getRange();
        return new CellRangeAddress(cellRangeAddress8Bit.getFirstRow(), cellRangeAddress8Bit.getLastRow(), cellRangeAddress8Bit.getFirstColumn(), cellRangeAddress8Bit.getLastColumn());
    }

    public CellRangeAddress removeArrayFormula(int n, int n2) {
        CellRangeAddress8Bit cellRangeAddress8Bit = this._sharedValueManager.removeArrayFormula(n, n2);
        this._formulaRecord.setParsedExpression(null);
        return new CellRangeAddress(cellRangeAddress8Bit.getFirstRow(), cellRangeAddress8Bit.getLastRow(), cellRangeAddress8Bit.getFirstColumn(), cellRangeAddress8Bit.getLastColumn());
    }
}

