/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.listeners;

import java.util.Collection;
import java.util.Optional;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tags;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkRuleChecker;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.listeners.AbstractPopupListener;

public class PropertyPopupListener
extends AbstractPopupListener {
    public PropertyPopupListener(MapFrame frame) {
        super(frame);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Tags tags = this.frame.propertiesDialog.getSelectedProperties();
        if (tags != null) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            Optional<BBox> bbox = MainApplication.getLayerManager().getEditDataSet().getSelected().stream().filter(x -> x.hasTag(tags.getKey(), (Collection)tags.getValues())).map(IPrimitive::getBBox).findAny();
            for (Link link : Tag2LinkRuleChecker.getLinks(tags, bbox.isPresent() ? bbox.get().getCenter() : null)) {
                this.addLink(popup, link);
            }
        }
    }
}

