/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tags;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.LinkPost;
import org.openstreetmap.josm.plugins.tag2link.data.Rule;
import org.openstreetmap.josm.plugins.tag2link.data.Source;
import org.openstreetmap.josm.plugins.tag2link.io.SourcesReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class Tag2LinkRuleChecker
implements Tag2LinkConstants {
    private static Collection<Source> sources = new ArrayList<Source>();
    private static boolean initialized = false;
    private static final Pattern PLACEHOLDERS = Pattern.compile("%([^%]*)%");
    private static final Pattern LANG = Pattern.compile(".*lang(?:\\((\\p{Lower}{2,})(?:,(\\p{Lower}{2,}))*\\))?.*");

    public static void init() {
        if (!initialized) {
            sources = SourcesReader.readSources();
            initialized = true;
        }
    }

    private static String findValue(String arg, Collection<Rule.MatchingTag> matchingTags) {
        for (Rule.MatchingTag tag : matchingTags) {
            if (!tag.params.containsKey(arg)) continue;
            return tag.params.get(arg);
        }
        return null;
    }

    private static String replaceParams(String s, Collection<Rule.MatchingTag> matchingTags, LatLon latLon) {
        String result = s;
        Matcher m = PLACEHOLDERS.matcher(s);
        while (m.find()) {
            String arg = m.group(1);
            String val = Tag2LinkRuleChecker.findValue(arg, matchingTags);
            if (val == null) {
                val = Tag2LinkRuleChecker.replaceLang(arg);
            }
            if (val == null && latLon != null) {
                val = Tag2LinkRuleChecker.replaceLatLon(arg, latLon);
            }
            if (val == null && arg.contains(":")) {
                String[] vars = arg.split(":");
                for (int i = 0; val == null && i < vars.length - 1; ++i) {
                    val = Tag2LinkRuleChecker.findValue(vars[i], matchingTags);
                }
                if (val == null) {
                    val = vars[vars.length - 1];
                }
            }
            if (val != null) {
                try {
                    if (s.contains("wikipedia.") || s.contains(".wikimedia.org")) {
                        val = val.replaceAll(" ", "_");
                    }
                    if (!m.group().equals(s)) {
                        val = URLEncoder.encode(val, "UTF-8");
                    }
                    result = result.replaceFirst(Pattern.quote(m.group()), val);
                }
                catch (UnsupportedEncodingException e) {
                    Logging.error((Throwable)e);
                }
                continue;
            }
            Logging.error((String)("Invalid argument: " + arg));
        }
        return result;
    }

    private static String replaceLang(String arg) {
        Matcher lm = LANG.matcher(arg);
        if (lm.matches()) {
            String josmLang = Config.getPref().get("language");
            String jvmLang = (josmLang.isEmpty() ? Locale.getDefault().getLanguage() : josmLang).split("_")[0];
            if (lm.groupCount() == 0) {
                return jvmLang;
            }
            for (int i = 1; i <= lm.groupCount(); ++i) {
                if (!jvmLang.equals(lm.group(i))) continue;
                return jvmLang;
            }
        }
        return null;
    }

    private static String replaceLatLon(String arg, LatLon ll) {
        switch (arg) {
            case "lat": {
                return Double.toString(ll.lat());
            }
            case "lon": {
                return Double.toString(ll.lon());
            }
        }
        return null;
    }

    private static void replaceMapParams(Map<String, String> map, Collection<Rule.MatchingTag> matchingTags, LatLon latLon) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            String key2 = Tag2LinkRuleChecker.replaceParams(key, matchingTags, latLon);
            String value2 = Tag2LinkRuleChecker.replaceParams(value, matchingTags, latLon);
            if (key.equals(key2) && value.equals(value2)) continue;
            if (key.equals(key2)) {
                map.put(key, value2);
                continue;
            }
            map.remove(key);
            map.put(key2, value2);
        }
    }

    private static Collection<Link> processEval(Rule.EvalResult eval, Rule rule, Source source, LatLon latLon) {
        ArrayList<Link> result = new ArrayList<Link>();
        if (eval.matches()) {
            for (Link link : rule.links) {
                try {
                    Link copy = link.clone();
                    copy.name = copy.name.replaceAll("%name%", source.name);
                    copy.url = Tag2LinkRuleChecker.replaceParams(copy.url, eval.matchingTags, latLon);
                    if (copy instanceof LinkPost) {
                        LinkPost lp = (LinkPost)copy;
                        Tag2LinkRuleChecker.replaceMapParams(lp.headers, eval.matchingTags, latLon);
                        Tag2LinkRuleChecker.replaceMapParams(lp.params, eval.matchingTags, latLon);
                    }
                    result.add(copy);
                }
                catch (CloneNotSupportedException e) {
                    Logging.error((Throwable)e);
                }
            }
        }
        return result;
    }

    private static <T> Collection<Link> doGetLinks(BiFunction<Rule, T, Rule.EvalResult> evaluator, T obj, LatLon latLon) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources) {
            for (Rule rule : source.rules) {
                result.addAll(Tag2LinkRuleChecker.processEval(evaluator.apply(rule, (Rule)obj), rule, source, latLon));
            }
        }
        return result;
    }

    public static Collection<Link> getLinks(IPrimitive p) {
        return Tag2LinkRuleChecker.doGetLinks(Rule::evaluates, p, p.getBBox().getCenter());
    }

    public static Collection<Link> getLinks(Tag tag, LatLon latLon) {
        return Tag2LinkRuleChecker.doGetLinks(Rule::evaluates, tag, latLon);
    }

    public static Collection<Link> getLinks(Tags tags, LatLon latLon) {
        return Tag2LinkRuleChecker.doGetLinks(Rule::evaluates, tags, latLon);
    }
}

